<?php

class SendToEmailAddressesForm extends BaseForm {

  public function configure() {
    $this->setWidgets(array(
        'emails' => new sfArtWidgetFormTextarea(array(), array('class' => 'no-ckeditor',  'cols' => 60, 'rows' => 10))
    ));

    $this->setValidators(array(
        'emails' => new sfValidatorString()
    ));


    $this->widgetSchema->setNameFormat('emails_send[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
  }

  public function save($con = null) {
    
    $messageCenterId = $this->getRequest()->getParameter('id');
    $emails = strip_tags($this->values['emails']);
    $emails_correct = array();
    $emails_broken = array();
    $lines = explode("\n", $emails);

    foreach ($lines as $index => $line) {
      
      $findCount = preg_match_all('/[a-zA-Z0-9.\-_]+@[a-zA-Z0-9\-.]+\.[a-zA-Z]{2,4}/', $line, $emails_preg);
      if ($findCount == 0) {
        trim($line);
        if (strlen($line) > 0) {
          array_push($emails_broken, strtolower($line));
        }
      }
      
      foreach ($emails_preg[0] as $email) {
        
        if (strlen($email) > 0) {
          if (!in_array($email, $emails_correct)) {
            array_push($emails_correct, strtolower($email));
            
          }
        }
      }
      
      
    }
    ArtSimpleMessenger::sendNewsletterToEmailArray($messageCenterId, $emails_correct);
    
  }
}