<?php

/**
 * PluginInternalMessage form.
 *
 * @package    ##PROJECT_NAME##
 * @subpackage form
 * @author     ##AUTHOR_NAME##
 * @version    SVN: $Id: sfDoctrineFormPluginTemplate.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
abstract class PluginInternalMessageForm extends BaseInternalMessageForm
{

  public function setup()
  {
    $this->setWidgets(array(
        'id' => new sfWidgetFormInputHidden(),
        'receiver_id' => new sfWidgetFormDoctrineChoice(array('model' => 'sfGuardUser', 'table_method' => 'getUsersWithoutLoggedInAndSystem', 'method' => 'getFirstAndLastName')),
        'title' => new sfWidgetFormInputText(),
        'description' => new sfWidgetFormTextarea(),
    ));

    $this->setValidators(array(
        'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
        'receiver_id' => new sfValidatorDoctrineChoice(array('model' => 'sfGuardUser', 'query' => Doctrine::getTable('sfGuardUser')->getUsersWithoutLoggedInAndSystem())),
        'title' => new sfValidatorString(array('max_length' => 100, 'required' => false)),
        'description' => new sfValidatorString(array('required' => false)),
    ));

    $this->widgetSchema->setNameFormat('internal_message[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
  }

  public function save($con = null)
  {
    $this->values['author_id'] = $this->getUserId();
    
    if ($this->values['title'] == '')
    {
      self::loadI18NHelper();
      $this->values['title'] = __('[No title]');
    }
    
    $internalConversation = new InternalConversation();
    $internalConversation->setTitle($this->values['title']);
    $internalConversation->save();
    
    $this->values['internal_conversation_id'] = $internalConversation->getId();
    
    $object = parent::save($con);
    
    InternalMessageCategory::addObject($object->getId(), InternalCategory::INBOX_ID, $this->values['receiver_id']);
    InternalMessageCategory::addObject($object->getId(), InternalCategory::ARCHIVE_ID, $this->values['receiver_id']);
    
    InternalMessageCategory::addObject($object->getId(), InternalCategory::OUTBOX_ID, $this->values['author_id']);
    InternalMessageCategory::addObject($object->getId(), InternalCategory::ARCHIVE_ID, $this->values['author_id']);
    
    return $object;
  }
}
