<?php

/**
 * PluginMessageCenter form.
 *
 * @package    ##PROJECT_NAME##
 * @subpackage form
 * @author     ##AUTHOR_NAME##
 * @version    SVN: $Id: sfDoctrineFormPluginTemplate.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
abstract class PluginMessageCenterForm extends BaseMessageCenterForm
{

  public function updateDefaultsFromObject()
  {
    parent::updateDefaultsFromObject();

    $userMessageSetting = Doctrine::getTable('UserMessageSetting')->getDefaultSettingForMessageCenter($this->object->getId());

    if ($userMessageSetting && $userMessageSetting->getEnabled() != 1)
      $this->setDefault('channel_enabled', false);
    else
      $this->setDefault('channel_enabled', 1);
  }

  public function setup()
  {
    $this->disableRequiredsFieldText();
    
    $this->setWidgets(array(
        'id' => new sfWidgetFormInputHidden(),
        'unique_name' => new sfWidgetFormInputText(array(), array('size' => 40)),
        'collector_class' => new sfWidgetFormInputText(array(), array('size' => 40)),
        'message_channel_id' => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('MessageChannel'), 'add_empty' => false)),
        'layout_id' => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Layout'), 'add_empty' => true)),
        'channel_enabled' => new sfWidgetFormInputCheckbox(),
    ));

    $this->setValidators(array(
        'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
        'channel_enabled' => new sfValidatorChoice(array('choices' => array('0', '1', 'on'), 'required' => false)),
        'message_channel_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('MessageChannel'))),
        'layout_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Layout'), 'required' => false)),
        'unique_name' => new sfValidatorString(array('max_length' => 45)),
        'collector_class' => new sfValidatorString(array('max_length' => 100)),
    ));

    $defaultChannelSetting = $this->getObject()->getDefaultChannelSetting();

    if ($defaultChannelSetting == 2)
      unset($this['channel_enabled']);
    else
      $this->setDefault('channel_enabled', $defaultChannelSetting);

    if (sfConfig::get('sf_environment') != 'dev')
      unset($this['message_channel_id'], $this['unique_name'], $this['collector_class']);

    //pobranie templatek do message center
//    $messageTemplates = Doctrine::getTable('MessageTemplate')->getTemplatesForMessageCenter($this->getObject()->getId());
//    $collectorClass = $this->getObject()->getCollectorClass();
//    
//    $orders = array();
//    
//    //pobranie tablicy zajętych numerków kolejności
//    foreach ($messageTemplates as $messageTemplate)
//      $orders[$messageTemplate->getOrder()] = $messageTemplate->getOrder();
    //dla kazdej templatki
//    foreach ($messageTemplates as $i => $messageTemplate)
//    {
//      //skopiowanie tablicy zajętych orderów
//      $order = $messageTemplate->getOrder();
//      $tempOrders = $orders;
//      //usunięcie z tablicy zajętych orderów obecnego orderu
//      unset($tempOrders[$order]);
//      
//      //zembedowanie formularza dla templatki, z przekazanymi parametrami m.in. tablicy zajętych orderów (żeby w formularzu nie można było ustawić konkretnego orderu.
//      $formName = 'message_template_' . $order;
//      $this->embedForm ($formName, new MessageTemplateForm($messageTemplate, array('without_orders' => $tempOrders, 'collector_class' => $collectorClass)));
//      $this->widgetSchema->setLabel($formName, __('Message template') . ' ' . $order);
//    }

    $this->widgetSchema->setLabel('layout_id', 'Message layout');

    $this->widgetSchema->setNameFormat('message_center[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
  }

  public function bind(array $taintedValues = null, array $taintedFiles = null)
  {
    if (isset($taintedValues['channel_enabled']) && $taintedValues['channel_enabled'] == 'on')
      $taintedValues['channel_enabled'] = 1;
    else if (isset($this->widgetSchema['channel_enabled']))
      $taintedValues['channel_enabled'] = 0;

    parent::bind($taintedValues, $taintedFiles);
  }

  public function save($con = null)
  {
    $object = parent::save($con);

    $userMessageSetting = Doctrine::getTable('UserMessageSetting')->getDefaultSettingForMessageCenter($object->getId());

    if ($userMessageSetting === false)
    {
      $userMessageSetting = new UserMessageSetting();
      $userMessageSetting->setMessageCenterId($object->getId());
    }

    $channelEnabled = isset($this->values['channel_enabled']) ? $this->values['channel_enabled'] : 2;
    
    $userMessageSetting->setEnabled($channelEnabled);
    $userMessageSetting->save();

    return $object;
  }

}
