<?php

/**
 * PluginMessageTemplate form.
 *
 * @package    ##PROJECT_NAME##
 * @subpackage form
 * @author     ##AUTHOR_NAME##
 * @version    SVN: $Id: sfDoctrineFormPluginTemplate.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
abstract class PluginMessageTemplateForm extends BaseMessageTemplateForm
{

  public function setup()
  {
    $withoutOrders = $this->getOption('without_orders', array());
    $collectorClass = $this->getOption('collector_class', null);

    $this->setWidgets(array(
        'id' => new sfWidgetFormInputHidden(),
        'order' => new sfArtWidgetFormSelectNumber(array('min' => 1, 'max' => 10, 'with_empty' => false, 'without_choices' => $withoutOrders))
    ));

    $this->setValidators(array(
        'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
        'order' => new sfValidatorInteger(),
    ));

    $this->embedI18nWithLabels();
    
    if (is_null($collectorClass))
    {
      $collectorClass = $this->getObject()->getMessageCenter()->getCollectorClass();
      unset($this['order']);
    }
    
    $collectorObject = new $collectorClass();
    $help = $collectorObject->getHelpString();
    
    $this->widgetSchema['legend'] = new sfArtWidgetFormText(array('content' => $help));
    
    $this->widgetSchema->setNameFormat('message_template[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
  }

  public function save($con = null)
  {
    $messageCenter = $this->getObject()->getMessageCenter();
    $messageCenter->setUpdatedAt(artDate::today());
    
    $messageCenter->save();

    return parent::save($con);
  }
}
