<?php

/**
 * Klasa zawierająca funkcje do wysylania wiadomości email.
 *
 * @package    artMessangerPlugin
 */
class PluginMessageSender {
  
  public function getComponentBody($module, $component, $vars = array(), $application = null) {
    $activeApp = sfContext::getInstance()->getConfiguration()->getApplication();

    if ($application) {
      sfContext::switchTo($application);
      $context = sfContext::getInstance();
    } else {
      $context = sfContext::getInstance();
    }
    
    $context = sfContext::getInstance();
    $actionName = '_' . $component;

    $view = new artPartialView($context, $module, $actionName, '');

    $view->setPartialVars(true === sfConfig::get('sf_escaping_strategy') ? sfOutputEscaper::unescape($vars) : $vars);

    if ($retval = $view->getCache()) {
      return $retval;
    }

    $allVars = View::callComponent($module, $component, $vars);
    
    if ($application) {
      sfContext::switchTo($activeApp);
    }

    if (null !== $allVars) {
      $view->getAttributeHolder()->add($allVars);

      return $view->render();
    }
  }

  /**
   * Funkcja wysyla wiadomosc zdefiniowana w parametrach
   * 
   * @param string $from Adresat
   * @param string $to Odbiorca
   * @param string $body Tresc wiadomosci
   * @param string $title Tytul wiadomosci
   * @param array $attachments Zalaczniki (nie testowane)
   */
  public function send($from, $to, $body, $title, $attachments = array()) {
    $msg = new Swift_Message($title);
    $msg->setTo($to);
    $msg->setFrom($from);
    $msg->setBody($this->addEmbedFilesToLayout($msg, $body), "text/html");
    
    $this->addAttachments($msg, $attachments);

    $mailer = sfContext::getInstance()->getMailer();
    $mailer->sendNextImmediately()->send($msg);
  }

  /**
   * Metoda dołącza obrazki z layoutu (z body wiadomości) do emaila i podmienia <img src= na adres wew. emaila (cid)
   * @param type $message
   * @param type $messageBody
   * @param type $withExternalImg - czy ma załadowywać zewnętrzne obrazki - rozpoczynające się od http (default false)
   * @return type
   */
  public function addEmbedFilesToLayout($message, $messageBody, $withExternalImg = false) {
    $cidArray = array(); //tablica do przechowywania cid'ow - adresów obrazka wewnątrz maila - aby nie ładować tego samego obrazka kilka razy

    preg_match_all('@<img[\n\t\r ]*.*?[\n\t\r ]*(src[\n\t\r ]*=[\n\t\r ]*[\'"]{1,1}(.*?)[\'"]{1,1})@', $messageBody, $matchesarray);

    foreach ($matchesarray[2] as $k => $img) {
      if (empty($img))
        continue;

      if (!artString::startsWith('http', $img))
        $file = sfConfig::get('sf_web_dir') . '/' . $img;
      else {
        if ($withExternalImg) //czy załączać do emaila obrazki z zewnętrznych serwerów?
          $file = $img;
        else
          continue;
      }

      if (!isset($cidArray[$file]))
        $cidArray[$file] = $message->embed(Swift_Image::fromPath($file));

      $m = str_replace($matchesarray[1][$k], 'src="' . $cidArray[$file] . '"', $messageBody);
      $messageBody = $m;
    }

    return $messageBody;
  }

  /**
   * Załącza pliki do emaila
   * @param type $message
   * @param type $attachments
   * @param type $withExternalAttachments - czy ma załączać pliki z zew. serwerów (default nie)
   * @return type
   */
  public function addAttachments($message, $attachments, $withExternalAttachments = false) {
    $cidArray = array(); //tablica do przechowywania cid'ow - adresów plików wewnątrz maila - aby nie ładować tego samego obrazka kilka razy

    foreach ($attachments as $k => $attachment) {
      if (empty($attachment))
        continue;

      if (!artString::startsWith('http', $attachment))
        $file = sfConfig::get('sf_web_dir') . '/' . $attachment;
      else {
        if ($withExternalAttachments) //czy załączać do emaila obrazki z zewnętrznych serwerów?
          $file = $attachment;
        else
          continue;
      }

      if (!isset($cidArray[$file]))
        $cidArray[$file] = $message->embed(Swift_Image::fromPath($file));
    }
  }

}
