<?php

/**
 
 */
class ArtMessenger extends BaseArtMessenger
{

    /**
     * @param type $messageType
     * @param type $params
     * @param type $destination jeżeli od danego użytkownika - podany jest id usera.
     *                          Jeżeli do niezarejestrowanego - tablica z podanym emailem itp
     * @param type $source jeżeli null, to znaczy że wysyła system. W przeciwnym wypadku podany user_id lub tablica z emailem itp
     */
    public static function send($messageType, $params = array(), $destination = null, $source = null)
    {
        $messenger = new ArtMessenger();

        $messenger->sendSingleMessage($messageType, $params, $destination, $source);
    }

    public static function multisend($sendLimit = 0, $params = array(), $destination = null, $source = null)
    {
        $messenger = new ArtMessenger();

        return $messenger->sendMultiMessage($sendLimit, $params, $destination, $source);
    }

    public static function multisendSingle($messageCenterId, $multisendTypeName, $params = array(), $destination = null, $source = null)
    {
        $messenger = new ArtMessenger();

        $messenger->sendMultiMessageOne($messageCenterId, $multisendTypeName, $params, $destination, $source);
    }

    public function sendMultiMessage($sendLimit = 0, $params = array(), $destination = null, $source = null)
    {
        $sendedCount = 0;
        $this->source = $source;

        if (is_null($this->source))
            $this->source = array();

        $messagesMultisendType = Doctrine::getTable('MessageMultisendType')->findAll();
        $messageAttachments = array();

        foreach ($messagesMultisendType as $multisendType) {
            $multisendTypeId = $multisendType->getId();
            $multisendTypeName = $multisendType->getName();

// pobranie danych do kolektora i danych do wysyłki emaili
            $functionName = 'getMessageListFor' . sfInflector::camelize($multisendTypeName);

            if (method_exists('MessageMultisendListTable', $functionName))
                $multisendLists = Doctrine::getTable('MessageMultisendList')->$functionName($multisendTypeId, $sendLimit);
            else
                $multisendLists = Doctrine::getTable('MessageMultisendList')->getMessageList($multisendTypeId, $sendLimit);

            foreach ($multisendLists as $messageMultisendList) {
                $this->destination = $destination;
                $this->params = $params;

                if (is_null($destination))
                    $this->destination = array();

                $messageCenterId = $messageMultisendList->getMessageCenterId();
                $this->params['messageMultisendList'] = $messageMultisendList;

                $this->messageCenter = $this->getMessageCenter($messageCenterId);
                $this->attachments = $this->getMessageFiles($messageCenterId);

                //metoda do pobierania danych do kolektora dla konkretnego rekordu messageMultisendList
                //wg mnie niepotrzebna, bo wtedy dane do kolektorów będą pobierane w kilku miejscach i bedzie to ciezko sprawdzac
                $collectorMethod = 'getColllectorDataFor' . sfInflector::camelize($multisendTypeName);

                if (!is_null($messageMultisendList->getNewsletterUserId()))
                    $this->params['newsletterUser'] = $messageMultisendList->getNewsletterUser();
                if (!is_null($messageMultisendList->getUserId()))
                    $this->params['User'] = $messageMultisendList->getSfGuardUser();

                if (method_exists('MessageMultisendList', $collectorMethod))
                    $this->params['collectorData'] = $messageMultisendList->$collectorMethod();

                $this->destination = array_merge($this->destination, $messageMultisendList->getDestinationArray());
                $this->source = array_merge($this->source, $messageMultisendList->getSourceArray());

                //przygotowanie danych do wysyłki
                $this->data = $this->getData();
                $this->templates = $this->getTemplates();
                $this->replaceDataInTemplates();
//                $this->layout = $this->getLayout();

                if ($this->sendByChannel() !== false)
                    $sendedCount++;

                $this->collectorObject = null;
            }
        }

        Doctrine::getTable('MessageMultisendList')->deleteMessageList();

        return $sendedCount;
    }

    public function sendMultiMessageOne($messageCenterId, $multisendTypeName, $params = array(), $destination = null, $source = null)
    {
        $this->params = $params;
        $this->destination = $destination;
        $this->source = $source;

        $this->messageCenter = Doctrine::getTable('MessageCenter')->getMessageInfoForMultiMessage($messageCenterId);
        $this->attachments = $this->messageCenter->getFiles();

        $this->data = $this->getData();
        $this->templates = $this->getTemplates();
        $this->replaceDataInTemplates();
//        $this->layout = $this->getLayout();

        $this->sendByChannel();

        $this->collectorObject = null;
    }

    public function sendSingleMessage($messageType, $params = array(), $destination = null, $source = null)
    {
        $this->params = $params;
        $this->destination = $destination;
        $this->source = $source;

        $this->messagesInfo = Doctrine::getTable('MessageCenter')->getMessageInfo($messageType, $this->destination);

        if ($this->messagesInfo->count() == 0 && !is_array($this->destination))
            $this->messagesInfo = Doctrine::getTable('MessageCenter')->getMessageInfo($messageType);

        if ($this->messagesInfo->count() == 0)
            throw new Exception('ArtMessanger no message center "' . $messageType . '"');

        foreach ($this->messagesInfo as $this->messageCenter) {
            if (is_array($destination) || $this->messageCenter->getUserMessageSettings()->getFirst()->getEnabled()) {
                //pobranie załączonych plików
                $this->attachments = Doctrine::getTable('MessageCenterFile')->getFilesForMessage($this->messageCenter->getId());
                $this->data = $this->getData();
                $this->templates = $this->getTemplates();
                $this->replaceDataInTemplates();
//                $this->layout = $this->getLayout();

                $this->sendByChannel();
            }
        }
    }

}
