<?php

class ArtSimpleMessenger
{

  /**
   * wysyłanie wiadomości o zaakceptowaniu przyjaźni 
   * @param bigint $from
   * @param bigint $to 
   */
  static function sendAcceptedInvitationMessage($from, $to)
  {
    ArtMessenger::send('invitation to friend accepted', array('friendId' => $to), $to, $from);
  }

  /**
   *  wiadomość o zaproszeniu do przyjaźni
   * @param type $from
   * @param type $to
   * @param type $link 
   */
  static function sendInvitationToFriendshipMessage($from, $to, $link)
  {
    ArtMessenger::send('invite friend', array('friendId' => $to, 'friend_link' => $link), $to, $from);
  }

  /**
   *  wiadmość rejestracyjna z linkiem aktywacyjnym
   * @param sfGuardUser $user 
   */
  static function sendRegistrationMessage($user, $withDeleteLink = true)
  {
    $link = self::getActivationLink($user);

    if ($withDeleteLink)
      $deleteUserLink = self::getDeleteUserLink($user);
    else
      $deleteUserLink = false;

    ArtMessenger::send('registration', array('link' => $link, 'delete_account_link' => $deleteUserLink), array('email' => $user->getEmailAddress()));
  }
  
  /**
   * wiadomość wysyłana do użytkownika, który chce skasować swoje konto
   * @param type $user 
   */
  static function sendDeleteAccountMessage($user)
  {
    $deleteAccountLink = self::getDeleteAccountLink($user);

    ArtMessenger::send('delete account', array('delete_account_link' => $deleteAccountLink, 'user' => $user), array('email' => $user->getEmailAddress()));
  }
  
  public static function sendInvitationToServiceMessage($destinationEmail, $inviter, $invitationObject)
  {
    $link = self::getInvitationToServiceLink($invitationObject);
    
    ArtMessenger::send('invite to service', array('link' => $link, 'user' => $inviter), array('email' => $destinationEmail));
  }

  /**
   *  wiadomość o pomyślnym aktywowaniu konta
   * @param type $user 
   */
  static function sendActivationMessage($user)
  {
    $link = self::getActivationLink($user);
    ArtMessenger::send('activation', array(), array('email' => $user->getEmailAddress()));
  }

  /**
   *  wiadomość o pomyślnym aktywowaniu newslettera
   * @param NewsletterUser $user 
   */
  static function sendActivateNewsletterMessage($newsletterUser)
  {
    ArtMessenger::send('activate newsletter', array('newsletterUser' => $newsletterUser), array('email' => $newsletterUser->getEmail()));
  }

  /**
   * wiadomość informująca o pomyślnej zmianie hasła
   * @param type $user 
   */
  static function sendNewPasswordMessage($user)
  {
    ArtMessenger::send('new password', array(), $user->getId());
  }
  
  static function sendContactFormMessage($email, $message )
  {
    ArtMessenger::send('contact_form', array( 'message' => $message), array('email' => $email) );
  }

  /**
   *  wiadomość z linkiem resetującym hasło
   * @param type $user_id
   * @param type $uniqueKey 
   */
  static function sendResetPasswordMessage($user_id, $uniqueKey)
  {
    ArtMessenger::send('reset password', array('link' => self::getResetPasswordLink($uniqueKey)), $user_id);
  }

  public static function sendNewsletterToEmail($messageCenterId, $email, $firstName = '', $lastName = '')
  {
    $newsletterUser = new NewsletterUser();
    $newsletterUser->setId(0);
    $newsletterUser->setEmail($email);
    $newsletterUser->setFirstName($firstName);
    $newsletterUser->setLastName($lastName);

    self::sendNewsletterToNewsletterUser($messageCenterId, $newsletterUser);
  }
  
  public static function sendNewsletterToEmailArray($messageCenterId, $emails,$max_message_count = -1)
  {
    if (empty($emails))
      return ;
    
    $email_string = "";
    foreach ($emails as $email)
    {
      if ($email_string != "")
        $email_string .= ",";
      
      $email_string .= "(''$email'')";
    }
    artQuery::executeSql("call send_newsletter_to_list (".$messageCenterId.",$max_message_count,'". $email_string ."')");
    
  }

  public static function sendNewsletterToNewsletterUser($messageCenterId, $newsletterUser)
  {
    ArtMessenger::multisendSingle($messageCenterId, 'newsletter', array('newsletterUser' => $newsletterUser), array('email' => $newsletterUser->getEmail()));
  }

  public static function sendNewsletterToGuardUser($messageCenterId, $guardUser)
  {
    self::sendNewsletterToEmail($messageCenterId, $guardUser->getEmailAddress(), $guardUser->getFirstName(), $guardUser->getLastName());
  }

  public static function sendNewsletterToSessionUser($messageCenterId, $sessionUser)
  {
    self::sendNewsletterToGuardUser($messageCenterId, $sessionUser->getGuardUser());
  }

  /**
   *  metoda generująca link aktywacyjny
   * @param type $user
   * @return url 
   */
  static function getActivationLink($user)
  {
    sfContext::getInstance()->getConfiguration()->loadHelpers('Url');
    $md5 = '1';

    if (!empty($user) && !is_string($user))
      $md5 = $user->getMd5ActivationCode();

    $link = self::removeBackend(url_for('@activate?e=' . $user->getEmailAddress() . '&u=' . $md5, true));

    return $link;
  }

  /**
   *  metoda generująca link resetujcy hasło
   * @param type $uniqueKey
   * @return url 
   */
  static function getResetPasswordLink($uniqueKey)
  {
    sfContext::getInstance()->getConfiguration()->loadHelpers('Url');
    return url_for('@sf_guard_forgot_password_change?unique_key=' . $uniqueKey, true);
  }

  public static function getDeleteUserLink($user)
  {
    sfContext::getInstance()->getConfiguration()->loadHelpers('Url');

    return self::removeBackend(url_for('@delete_new_user?hash=' . self::createDeleteUserHash($user), true));
  }

  public static function createDeleteUserHash(sfGuardUser $user)
  {
    $hash = md5($user->getId() . $user->getCreatedAt() . $user->getEmailAddress());
    $hash = substr_replace($hash, $user->getId(), 16, 0);

    return $hash;
  }

  public static function extractDeleteUserHash($hash)
  {
    $userId = substr($hash, 16, strlen($hash) - 32);

    $user = Doctrine::getTable('sfGuardUser')->getSessionGuardUser($userId);

    if ($user !== false && self::createDeleteUserHash($user) == $hash && !$user->getIsActive())
      return $user;
    else
      return false;
  }

  public static function getInvitationToServiceLink($object)
  {
    sfContext::getInstance()->getConfiguration()->loadHelpers('Url');

    return self::removeBackend(url_for('@invitation_to_service?hash=' . self::createInvitationToServiceHash($object), true));
  }

  public static function createInvitationToServiceHash($object)
  {
    $hash = md5($object->getId() . $object->getCreatedAt() . $object->getId());
    $hash = substr_replace($hash, $object->getId(), 16, 0);

    return $hash;
  }

  public static function extractInvitationToServiceHash($hash)
  {
    $id = substr($hash, 16, strlen($hash) - 32);

    $object = Doctrine::getTable('Invitation')->find($id);

    if ($object !== false && self::createInvitationToServiceHash($object) == $hash)
      return $object;
    else
      return false;
  }

  public static function getDeleteAccountLink($user)
  {
    sfContext::getInstance()->getConfiguration()->loadHelpers('Url');

    return self::removeBackend(url_for('@delete_account?hash=' . self::createDeleteAccountHash($user), true));
  }

  public static function createDeleteAccountHash(sfGuardUser $user)
  {
    $hash = md5($user->getId() . $user->getCreatedAt() . $user->getEmailAddress());
    $hash = substr_replace($hash, $user->getId(), 6, 0);

    return $hash;
  }

  public static function extractDeleteAccountHash($hash)
  {
    $userId = substr($hash, 6, strlen($hash) - 32);
    $user = Doctrine::getTable('sfGuardUser')->getSessionGuardUser($userId);

    if ($user !== false && self::createDeleteAccountHash($user) == $hash)
      return $user;
    else
      return false;
  }

  public static function removeBackend($link)
  {
    return str_replace(array('backend.php/', 'backend_dev.php/'), '', $link);
  }

}

