<?php
/**
 * Description of BaseArtMessenger
 *
 
 */
class BaseArtMessenger
{
    /**
     * @var Doctrine_Collection
     */
    public $messagesInfo;
    /**
     *
     * @var MessageCenter
     */
    public $messageCenter;
    /**
     *
     * @var BaseMessageCollector
     */
    public $collectorObject = null;
    public $data;
    public $templates = array();
    public $layout;
    public $params = array();
    public $destination;
    public $source;
    public $messageCenters = array();

    public function __construct()
    {
        sfContext::getInstance()->getConfiguration()->loadHelpers(array('ArteneoPartial'));
    }

    public function sendByChannel()
    {
        $channelClass = $this->messageCenter->getMessageChannel()->getChannelClass();
        $sendInfo = $this->getCollectorObject()->getSendInfo();

        if (!isset($sendInfo['attachments']))
            $sendInfo['attachments'] = array();

        $sendInfo['attachments'] = array_merge($sendInfo['attachments'], $this->attachments);

        if (isset($this->params['attachments']))
            $sendInfo['attachments'] = array_merge($sendInfo['attachments'], $this->params['attachments']);

        $sendInfo['params'] = $this->params;
        $sendInfo['messageCenter'] = $this->messageCenter;

        $channelObject = new $channelClass($sendInfo, $this->getMessage(), $this->templates['title']);

        return $channelObject->getSendStatus();
    }

    /**
     *
     * @param type $params
     * @return BaseMessageCollector
     */
    public function getCollectorObject()
    {
        if (is_null($this->collectorObject)) {
            $collectorClassName = $this->messageCenter->getCollectorClass();
            if (isset($this->params['collectorData']))
                $this->collectorObject = new $collectorClassName($this->params, $this->destination, $this->source, $this->params['collectorData']);
            else
                $this->collectorObject = new $collectorClassName($this->params, $this->destination, $this->source);
        }

        return $this->collectorObject;
    }

    public function getData()
    {
        return $this->getCollectorObject()->getData();
    }

    public function getTemplates()
    {
        $templates = array('title' => null);

        foreach ($this->messageCenter->getMessageTemplates() as $template) {
            $title = $template->getTitle();
            $order = $template->getOrder();

            if (!isset($templates['title']) && isset($title))
                $templates['title'] = $title;

            $order = isset($order) ? $order : 1;
            $templates['description'][$order] = $template->getDescription();
        }

        return $templates;
    }

    public function getLayout()
    {
        if (!$this->messageCenter->hasLayout())
            return false;
        else {
            $layout = $this->messageCenter->getLayout();
            $html = '';
//                    $layout->getHtml();

            if (isset($html))
                return $this->insertTemplatesIntoHtml($html);
            else {
                if (isset($this->templates['description']))
                    $templates = $this->templates['description'];
                else
                    $templates = array();

                if (isset($this->templates['title']))
                    $title = $this->templates['title'];
                else
                    $title = array();

                return get_partial($layout->getView(), array('templates' => $templates, 'title' => $title));
            }
        }
    }

    public function replaceDataInTemplates()
    {
        if (isset($this->templates['title']))
            $this->replaceData($this->templates['title']);

        if (isset($this->templates['description']))
            foreach ($this->templates['description'] as $key => $description)
                $this->replaceData($this->templates['description'][$key]);
    }

    protected function replaceData(&$text)
    {
        $text = str_replace(array_keys($this->data), $this->data, $text);
        foreach ($this->data as $key => $value) {
            //data z parametrem
            $pos = strpos($key, ':');
            if ($pos !== FALSE) {
                $needle = substr($key, 0, $pos + 1);
                preg_match_all('/\\' . $needle . '(.*?)\\}/', $text, $matches, PREG_SET_ORDER);
                foreach ($matches as $val)
                    $text = str_replace($val[0], $value . $val[1], $text);
            }
        }
    }

    public function insertTemplatesIntoHtml($html)
    {
        foreach ($this->templates as $key => $template)
            $html = str_replace('{' . $key . '}', $template['description'], $html);

        return $html;
    }

    public function getMessage()
    {
        if ($this->layout !== false)
            return $this->layout;
        else
            return implode(chr(13), $this->templates['description']);
    }

    public function getMessageCenter($messageCenterId)
    {
        if (!isset($this->messageCenters[$messageCenterId]))
            $this->messageCenters[$messageCenterId] = Doctrine::getTable('MessageCenter')->getMessageInfoForMultiMessage($messageCenterId);

        return $this->messageCenters[$messageCenterId];
    }

    public function getMessageFiles($messageCenterId)
    {
        if (!isset($this->messageCenterFiles[$messageCenterId]))
            $this->messageCenterFiles[$messageCenterId] = Doctrine::getTable('MessageCenterFile')->getFilesForMessage($messageCenterId);

        return $this->messageCenterFiles[$messageCenterId];
    }
}
