<?php

/**
 * Description of BaseMessageCollector
 *
 
 */
class BaseMessageCollector
{

    /**
     * @var myUser
     */
    public static $user = null;

    /**
     * @var array
     */
    public $params;

    /**
     * @var array/int
     */
    public $destination;

    /**
     * @var array/int
     */
    public $source;
    public $data;

    public static $usersObjects = array();
    public static $systemUserId = null;

    /**
     * @param array $params
     */
    public function __construct($params = array(), $destination = null, $source = null, $data = null)
    {
        sfContext::getInstance()->getConfiguration()->loadHelpers(array('I18N'));
        $this->params = $params;
        $this->destination = $destination;
        $this->source = $source;

        if ($data != null) {

            if (!is_array($data))
                $data = array();

            if (isset ($this->data))
                $this->data = array();

            if (!is_array($this->data))
                $this->data = array();

            $this->data = array_merge($this->data, $data);
        }
    }

    /**
     * funkcja służy do przygotowania danych dynamicznie podmienianych w treści wiadomości
     * @return array
     */
    public function prepareData()
    {
        if (isset($this->params['title']))
            $this->data['title'] = $this->params['title'];
        if (isset($this->params['description']))
            $this->data['description'] = $this->params['description'];

        return $this->data;
    }

    public function processArrayData($array, $prefix)
    {
        $values = array();

        if ($array instanceof sfDoctrineRecord)
            $array = $array->toArray();

        foreach ($array as $name => $value) {
            if (!is_array($value) && !in_array($name, array('password', 'password_again'))) {
                $this->data[$prefix . '.' . $name] = $value;
                $values[] = $name . ' = ' . $value;
            }
        }

        $this->data[$prefix] = implode(chr(13), $values);
    }

    /**
     * funkcja zwraca tablicę danych dynamicznie podmienianych w treści wiadomości
     * @return array
     */
    public function getData()
    {
        $newData = array();
        $data = $this->prepareData();

        if (!is_array($data))
            $data = array();

        foreach ($data as $key => $value)
            $newData['{' . $key . '}'] = $value;

        return $newData;
    }

    /**
     * funkcja pobiera tablicę ustawień potrzebnych do wysłania wiadomości wszystkimi kanałami
     * @return array
     */
    public function getSendInfo()
    {
        $info = array();

        $info = $this->getSendInfoDestination($info);
        $info = $this->getSendInfoSource($info);

        if (isset($this->params['internal_categories']))
            $info['internal_categories'] = $this->params['internal_categories'];
        else
            $info['internal_categories'] = array(InternalCategory::INBOX_ID);

        return $info;
    }

    /**
     * funkcja ustawia tablicę $sendInfo, a dokładniej dane źródła
     * @param array $info
     * @return array
     */
    public function getSendInfoSource($info)
    {
        if (is_array($this->source) && !empty($this->source)) //jeżeli ma być wysłane do usera bez konta
        {
            if (isset($this->source['email']))
                $info['source_email'] = $this->source['email'];

            if (isset($this->source['internal']))
                $info['source_internal'] = $this->source['internal'];
        } else if (is_null($this->source) || (is_array($this->source) && empty($this->source))) //jeżeli jest wysyłane przez system
        {
            $system = $this->getUserObject(null, sfGuardUser::$systemAccountUsername);

            if ($system === false)
                throw new sfException('Zdefiniuj użytkownika System!');

            $info['source_email'] = $system->getEmailAddress();
            $info['source_newsletter'] = $system->getEmailAddress();
            $info['source_user_id'] = $system->getId();
            $info['source_internal'] = $system->getId();

        } else //jeżeli jest wysyłane przez konkretnego usera
        {
            if ($this->source == $this->getUser()->getId())
                $user = $this->getUser()->getGuardUser();
            else
                $user = $this->getUserObject($this->source);

            $info['source_email'] = $user->getEmailAddress();
            $info['source_user_id'] = $user->getId();
            $info['source_internal'] = $user->getId();
        }

        return $info;
    }

    /**
     * funkcja ustawia tablicę $sendInfo, a dokładniej dane przeznaczenia
     * @param array $info
     * @return array
     */
    public function getSendInfoDestination($info)
    {
        if (is_array($this->destination) && !empty($this->destination)) //jeżeli ma być wysłane do usera bez konta
        {
            if (isset($this->destination['email']))
                $info['destination_email'] = $this->destination['email'];

            if (isset($this->destination['gg']))
                $info['destination_gg'] = $this->destination['gg'];

            if (isset($this->destination['internal']))
                $info['destination_internal'] = $this->destination['internal'];
        } //jeżeli ma być wysłane od konkretnego użytkownika - jest podany user_id
        else {
            if ($this->destination == $this->getUser()->getId())
                $user = $this->getUser()->getGuardUser();
            else
                $user = $this->getUserObject($this->destination);

            $info['destination_email'] = $user->getEmailAddress();
            $info['destination_user_id'] = $user->getId();
            $info['destination_internal'] = $user->getId();
        }

        return $info;
    }

    /**
     *
     * @param type $userId
     * @return sfGuardUser
     */
    public function getUserObject($userId, $username = null)
    {
        //jeżeli jest zapytanie i konto systemowe
        if (is_null($userId) && $this->isSystemAccount($username) && !is_null(self::$systemUserId))
            $userId = self::$systemUserId;

        if ($userId instanceof sfGuardUser)
            $userId = $userId->getId();

        //jeżeli nie istnieje obiekt w statycznej tablicy, to pobierz
        if (!isset(BaseMessageCollector::$usersObjects[$userId])) {
            $user = Doctrine::getTable('sfGuardUser')->getUserObjectForCollector($userId, $username);

            if (!$user)
                return false;

            $userId = $user->getId();

            if ($this->isSystemAccount($username))
                self::$systemUserId = $userId;

            BaseMessageCollector::$usersObjects[$userId] = $user;
        }

        return BaseMessageCollector::$usersObjects[$userId];
    }

    /**
     * Sprawdzanie czy podany username jest nazwa konta systemowego
     * @return boolean
     */
    public function isSystemAccount($username)
    {
        return sfGuardUser::$systemAccountUsername == $username;
    }

    /**
     * funkcja pobiera tablicę podpowiedzi do backendu, a następnie do kluczy dodaje {}, a wartości tłumaczy
     * @return array
     */
    public function getHelps()
    {
        $helps = $this->setHelps();
        $newHelps = array();

        foreach ($helps as $name => $description)
            $newHelps['{' . $name . '}'] = __($description);

        return $newHelps;
    }

    /**
     * funkcja pobiera stringa do wyświetlenia podpowiedzi do backendu
     * @return string
     */
    public function getHelpString()
    {
        $stringArray = array();

        foreach ($this->getHelps() as $name => $description)
            $stringArray[] = $name . ': ' . $description;

        return implode('<br />', $stringArray);
    }

    /**
     * funkcja do ustawiania podpowiedzi w backendzie
     * @return array
     */
    public function setHelps()
    {
        return array();
    }

    /**
     * pobiera zalogowanego użytkownika z sesji
     * @return myUser
     */
    public function getUser()
    {
        if (is_null(self::$user))
            self::$user = sfContext::getInstance()->getUser();

        return self::$user;
    }
}