<?php

/**
 * Description of BaseMessageCollectorNewsletter
 *
 
 */
class BaseMessageCollectorNewsletter extends BaseMessageCollector
{

  public function prepareData()
  {
    $this->data = parent::prepareData();
    
    if (isset ($this->params['newsletterUser']) && $this->params['newsletterUser'] != null)
    {
      $newsletterUser = $this->params['newsletterUser'];

      $this->data['user_email'] = $newsletterUser->getNewsletterEmail();
      $this->data['user_first_name'] = $newsletterUser->getNewsletterFirstName();
      $this->data['user_last_name'] = $newsletterUser->getNewsletterLastName();
      $this->data['signout_link'] = MessageMultisendList::getSignOutNewsletterLink($newsletterUser);
      $this->data['signin_link'] = MessageMultisendList::getSignInNewsletterLink($newsletterUser);
      
      if (MessengerSettings::hasTags())
      {
        $this->data['signout_tag_link:'] = MessageMultisendList::getSignOutTagNewsletterLink($newsletterUser);
        $this->data['signin_tag_link:'] = MessageMultisendList::getSignInTagNewsletterLink($newsletterUser);
        $this->data['tag_link:'] = MessageMultisendList::getTagNewsletterLink($newsletterUser);
      }
    }
    
    if (isset ($this->params['User']) && $this->params['User'] != null)
    {
      $User = $this->params['User'];

      $this->data['user_email'] = $User->getEmailAddress();
      $this->data['user_first_name'] = $User->getFirstName();
      $this->data['user_last_name'] = $User->getLastName();
      $this->data['signout_link'] = "";
      $this->data['signin_link'] = "";
      
      if (MessengerSettings::hasTags())
      {
        $this->data['signout_tag_link:'] = "X";
        $this->data['signin_tag_link:'] = "Y";
        $this->data['tag_link:'] = "X";
      }
    }
    
    
    return $this->data;
  }

  public function setHelps()
  {
    $helps = parent::setHelps();
    $helps['user_first_name'] = 'User first name';
    $helps['user_last_name'] = 'User last name';
    $helps['user_email'] = 'User email';
    $helps['signout_link'] = 'Signout link';
    $helps['signin_link'] = 'Signin link';
    
    if (MessengerSettings::hasTags())
      {
        $helps['signout_tag_link:'] = 'Signout link with tag eg. {signout_tag_link:TAG}';
        $helps['signin_tag_link:'] = 'Signin link with tag eg. {signin_tag_link:TAG}';
        $helps['tag_link:'] = 'Tag link eg. {tag_link:TAG}';
      }
    
    return $helps;
  }

}
