<?php

/**
 * Description of MessageCollectorInviteFriend
 *
 
 */
class MessageCollectorInviteFriend extends BaseMessageCollector
{

  public function prepareData()
  {
    $this->data = parent::prepareData();
    
    $inviter = $this->getUserObject($this->source);
    $friend = $this->getUserObject($this->params['friendId']);
    
    $this->data['inviter_name'] = $inviter->getName();
    $this->data['inviter_email'] = $inviter->getEmailAddress();
    $this->data['friend_name'] = $friend->getName();
    $this->data['friend_email'] = $friend->getEmailAddress();
    
    if (isset ($this->params['friend_link']))
      $this->data['friend_link'] = $this->params['friend_link'];
    
    return $this->data;
  }
  
  public function setHelps()
  {
    $helps = parent::setHelps();
    
    $helps['inviter_name'] = 'Inviter name';
    $helps['inviter_email'] = 'Inviter email';
    $helps['friend_name'] = 'Name of person who you would like to invite';
    $helps['friend_email'] = 'Email of person who you would like to invite';
    $helps['friend_link'] = 'Link to accept friendship';
    
    return $helps;
  }
}
