<?php

class MessageCollectorSfGuardUser extends BaseMessageCollector
{
  
  public function prepareData()
  {
    $this->data = parent::prepareData();
    
    if (isset ($this->params['link']))
      $this->data['link'] = $this->params['link'];
    if (isset ($this->params['delete_account_link']) && $this->params['delete_account_link'])
    {
      $this->data['delete_user_link'] = $this->params['delete_account_link'];
      $this->data['delete_account_link'] = $this->params['delete_account_link'];
    }
    
    if (isset($this->params['user']))
    {
      $this->data['first_name'] = $this->params['user']->getFirstName();
      $this->data['surname'] = $this->params['user']->getLastName();
      $this->processArrayData($this->params['user'], 'user');
    }
    
    return $this->data;
  }
  
  public function setHelps()
  {
    $helps = parent::setHelps();
    
    $helps['link'] = 'Activation link.';
    $helps['delete_account_link'] = 'Link to delete account.';
    $helps['first_name'] = 'User first name.';
    $helps['surname'] = 'User surname.';
    
    return $helps;
  }
}