<?php

/**
 * PluginInternalCategoryTable
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 */
class PluginInternalCategoryTable extends artDoctrineTable
{

  /**
   * Returns an instance of this class.
   *
   * @return object PluginInternalCategoryTable
   */
  public static function getInstance()
  {
    return Doctrine_Core::getTable('PluginInternalCategory');
  }

  public function getUserCategories($withoutCategoriesIds = array())
  {
    return $this->createQuery('ic')
            ->where('(ic.user_id IS NULL OR ic.user_id = ?)', $this->getUserId())
            ->andWhereNotIn('ic.id', $withoutCategoriesIds)
            ->orderBy('ic.id ASC')
            ->execute();
  }
  
  public function getUserCategoriesWithoutArchive()
  {
    return $this->getUserCategories(array(InternalCategory::ARCHIVE_ID));
  }

  public function getUserCategoriesForWidget($userId = null)
  {
    if (is_null($userId))
      $userId = $this->getUserId();
    
    $activeCategoryId = $this->getUser()->getAttribute('internal_category_id', 0, 'internal_messages');;
    
    return $this->createQuery('ic')
            ->where('(ic.user_id = ? OR ic.id IN (?, ?))', array($userId, InternalCategory::INBOX_ID, InternalCategory::OUTBOX_ID))
            ->andWhere('ic.id <> ?', $activeCategoryId)
            ->orderBy('ic.user_id ASC, ic.name ASC');
  }
  
}