<?php

/**
 * PluginInternalMessage
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @package    ##PACKAGE##
 * @subpackage ##SUBPACKAGE##
 * @author     ##NAME## <##EMAIL##>
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class PluginInternalMessage extends BaseInternalMessage
{
  public static $userId = null;
  
  public function getReceiver()
  {
    return $this->getSfGuardUser();
  }

  public function getAuthor()
  {
    return $this->getSfGuardAuthor();
  }
  
  public function isAuthorOrReceiver($userId = null)
  {
    return $this->isAuthor($userId) || $this->isReceiver($userId);
  }
  
  public function isReceiver($userId = null)
  {
    if (is_null($userId))
      $userId = $this->getUserId();
    
    return $this->getReceiverId() == $userId;
  }
  
  public function isAuthor($userId = null)
  {
    if (is_null($userId))
      $userId = $this->getUserId();
    
    return $this->getAuthorId() == $userId;
  }
  
  public function getUserId()
  {
    if (is_null(self::$userId))
      self::$userId = sfContext::getInstance()->getUser()->getId();
    
    return self::$userId;
  }
  /**
   *
   * @param type $title
   * @param type $description
   * @param type $authorId
   * @param type $receiverId
   * @param type $conversationId
   * @return InternalMessage 
   */
  public static function createNewMessage($title, $description, $authorId = null, $receiverId = null, $conversationId = null)
  {
    $messageObject = new InternalMessage();
    $messageObject->setDescription($description);
    $messageObject->setTitle($title);
    $messageObject->setAuthorId($authorId);
    $messageObject->setReceiverId($receiverId);
    
    if (is_null($conversationId))
    $messageObject->setInternalConversation(InternalConversation::createNewConversation($title));
    else
      $messageObject->setInternalConversationId($conversationId);
    
    $messageObject->save();
    
    return $messageObject;
  }
  
  public static function moveToTrash(sfWebRequest $request, $messagesIds)
  {
    $userId = BaseForm::getUserId();
    $ok = true;
    $messagesObjects = Doctrine::getTable('InternalMessage')->getByIds($messagesIds);
    
    foreach ($messagesObjects as $messageObject)
    {
      $messageId = $messageObject->getId();
      
      if ($messageObject->isAuthorOrReceiver($userId))
      {
        Doctrine::getTable('InternalMessageCategory')->deleteCategories($messageId, $userId);
        InternalMessageCategory::addToTrash($messageId, $userId);
      }
      else
        $ok = false;
    }
    
    return $ok;
  }
  
  public static function deleteCompletely(sfWebRequest $request, $messagesIds)
  {
    $userId = BaseForm::getUserId();
    $ok = true;
    $messagesObjects = Doctrine::getTable('InternalMessage')->getByIds($messagesIds);
    
    foreach ($messagesObjects as $messageObject)
    {
      $messageId = $messageObject->getId();
      
      if ($messageObject->isAuthorOrReceiver($userId))
      {
        $table = Doctrine::getTable('InternalMessageCategory');
        $table->deleteCategories($messageId, $userId);

        if ($table->findByInternalMessageId($messageId)->count() == 0)
          $messageObject->delete();
      }
      else
        $ok = false;
    }
    
    return $ok;
  }
  
}