<?php

/**
 * PluginInternalMessageCategory
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @package    ##PACKAGE##
 * @subpackage ##SUBPACKAGE##
 * @author     ##NAME## <##EMAIL##>
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class PluginInternalMessageCategory extends BaseInternalMessageCategory
{

  public static function addObject($messageId, $categoryId, $userId)
  {
    $object = new InternalMessageCategory();
    $object->setInternalMessageId($messageId);
    $object->setInternalCategoryId($categoryId);
    $object->setUserId($userId);
    $object->save();
    
    return $object;
  }

  public static function addToTrash($messageId, $userId)
  {
    return self::addObject($messageId, InternalCategory::TRASH_ID, $userId);  
  }
  
  public static function addToCategories($userId, $messagesIds, $userCategories)
  {
    if (!self::checkMessagesBelongingToUser($messagesIds, $userId))
      return false;

    Doctrine::getTable('InternalMessageCategory')->addToCategories($userId, $messagesIds, $userCategories);
      
    return true;
  }
  
  public static function moveToCategories($userId, $messagesIds, $userCategories, $oldCategoryId)
  {
    if (!self::checkMessagesBelongingToUser($messagesIds, $userId))
      return false;
    
    Doctrine::getTable('InternalMessageCategory')->moveToCategories($userId, $messagesIds, $userCategories, $oldCategoryId);
    
    return true;
  }
  
  public static function checkMessagesBelongingToUser($messagesIds, $userId)
  {
    $messagesCount = Doctrine::getTable('InternalMessage')->getMessagesBelongingToUser($messagesIds, $userId)->count();
    
    return $messagesCount == count($messagesIds);
  }

}