<?php

/**
 * PluginInternalMessageTable
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 */
class PluginInternalMessageTable extends artDoctrineTable
{

  /**
   * Returns an instance of this class.
   *
   * @return object PluginInternalMessageTable
   */
  public static function getInstance()
  {
    return Doctrine_Core::getTable('PluginInternalMessage');
  }

  public function getMessagesForCategory(Doctrine_Query $query)
  {
    $rootAlias = $query->getRootAlias();
    $userId = $this->getUserId();
    $categoryId = $this->getRequest()->getParameter('category_id', null);
    
    if (is_null($categoryId))
      $categoryId = $this->getUser()->getAttribute('internal_category_id', 0, 'internal_messages');
    
    
    $query->leftJoin($rootAlias . '.internalMessageCategories imc')
          ->leftJoin($rootAlias . '.sfGuardUser sfgu')
          ->leftJoin($rootAlias . '.sfGuardAuthor sfga')
          ->andWhere("($rootAlias.author_id = ? OR $rootAlias.receiver_id = ?)", array($userId, $userId))
          ->andWhere('imc.user_id = ?', $userId);
    
    if($categoryId != 0)
      $query->andWhere('imc.internal_category_id = ?', $categoryId);
    else
      $query->andWhere('imc.internal_category_id <> ?', InternalCategory::TRASH_ID)
              ->groupBy($rootAlias . '.id');
    
    return $query;
  }
  
  public function getByIds($messagesIds)
  {
    return $this->createQuery()
            ->whereIn('id', $messagesIds)
            ->execute();
  }
  
  public function getMessagesBelongingToUser($messagesIds, $userId)
  {
    return $this->createQuery()
            ->whereIn('id', $messagesIds)
            ->andWhere("(author_id = ? OR receiver_id = ?)", array($userId, $userId))
            ->execute();
  }
}