<?php

/**
 * PluginMessageCenter
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @package    ##PACKAGE##
 * @subpackage ##SUBPACKAGE##
 * @author     ##NAME## <##EMAIL##>
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class PluginMessageCenter extends BaseMessageCenter
{

  const _NO_NEWSLETTER = 0;
  const _NEWSLETTER = 1;
  const _BASE_NEWSLETTER = 2;
  
  public function __toString()
  {
    return sfContext::getInstance()->getI18N()->__($this->getUniqueName());
  }
  
  public function hasLayout()
  {
    return !$this->getLayout()->isNew();
  }

  public function getDefaultChannelSetting()
  {
    foreach ($this->getUserMessageSettings() as $object)
    {
      if ($object->getUserId() == null)
        return $object->getEnabled();
    }
    
    if ($this->isNew())
      return 1;

    $object = new UserMessageSetting();
    $object->setMessageCenterId($this->getId());
    $object->setEnabled(1);
    $object->save();

    return $object->getEnabled();
  }
  
  public function getBackendUniqueName() {
    $uniqueName = $this->getUniqueName();
    if ($uniqueName == '') {
      return __('Unikalna nazwa niezdefiniowana.');
    } else {
      return $uniqueName;
    }
  }
  
  public function getTitle()
  {
    if ($this->getMessageTemplates()->count() > 0) {
      return $this->getMessageTemplates()->getFirst()->getTitle();
    } else {
      return __('Brak Message Template, skontaktuj się z administratorem.');
    }
    
  }
  
  public function getDescription()
  {
    return $this->getMessageTemplates()->getFirst()->getDescription();
  }
  
  public static function copyObjectWithTemplatesAndSettings($messageCenterId)
  {
    $messageCenter = Doctrine::getTable('MessageCenter')->getMessageCenterWithTemplates($messageCenterId);
    $newMessageCenter = $messageCenter->copy();
    $newMessageCenter->save();
    $newMessageCenterId = $newMessageCenter->getId();
    $messageTemplates = $messageCenter->getMessageTemplates();

    foreach ($messageTemplates as $messageTemplate)
    {
      $newMessageTemplate = $messageTemplate->copy();
      $newMessageTemplate->setMessageCenterId($newMessageCenterId);
      $newMessageTemplate->save();
      $newMessageTemplateId = $newMessageTemplate->getId();

      foreach ($messageTemplate->__get('Translation') as $messageTemplateTranslation)
      {
        $newMessageTemplateTranslation = $messageTemplateTranslation->copy();
        $newMessageTemplateTranslation->__set('id', $newMessageTemplateId);
        $newMessageTemplateTranslation->save();
      }
    }

    $userMessageSettings = new UserMessageSetting();
    $userMessageSettings->setMessageCenterId($newMessageCenterId);
    $userMessageSettings->setEnabled($messageCenter->getDefaultChannelSetting());
    $userMessageSettings->save();
    
    return $newMessageCenter;
  }
  
  public static function copyBaseNewsletterToNew()
  {
    $messageCenter = Doctrine::getTable('MessageCenter')->getBaseNewsletterMessageCenter();
    $newMessageCenter = $messageCenter->copy();
    $newMessageCenter->setNewsletter(MessageCenter::_NEWSLETTER);
    $newMessageCenter->save();
    $newMessageCenterId = $newMessageCenter->getId();
    $messageTemplates = $messageCenter->getMessageTemplates();

    foreach ($messageTemplates as $messageTemplate)
    {
      $newMessageTemplate = $messageTemplate->copy();
      $newMessageTemplate->setMessageCenterId($newMessageCenterId);
      $newMessageTemplate->save();
      $newMessageTemplateId = $newMessageTemplate->getId();

      foreach ($messageTemplate->__get('Translation') as $messageTemplateTranslation)
      {
        $newMessageTemplateTranslation = $messageTemplateTranslation->copy();
        $newMessageTemplateTranslation->__set('id', $newMessageTemplateId);
        $newMessageTemplateTranslation->save();
      }
    }

    return $newMessageCenter;
  }
  
  public function getFiles()
  {
    $files = array();
    
    foreach ($this->getMessageCenterFiles() as $file)
      $files[] = $file->getFile();
    
    return $files;
  }

}