<?php

/**
 * PluginMessageCenterTable
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 */
class PluginMessageCenterTable extends artDoctrineTable
{

  /**
   * Returns an instance of this class.
   *
   * @return object PluginMessageCenterTable
   */
  public static function getInstance()
  {
    return Doctrine_Core::getTable('PluginMessageCenter');
  }

  public function getMessageInfo($messageType, $destination = null)
  {
    $query = $this->createQuery('mc')
            ->leftJoin('mc.MessageChannel mch')
            ->leftJoin('mc.messageTemplates mt')
            ->leftJoin('mc.messageCenterFiles mcf')
            ->leftJoinTranslation('mt')
            ->where('mc.unique_name = ?', $messageType)
            ->orderBy('mc.id ASC, mt.order ASC');

    if (is_array($destination))
      $query->andWhereIn('mch.channel', array_keys($destination));
    else
    {
      if (is_null($destination))
        $query->andWhere('ums.user_id IS NULL');
      else
      {
        if ($destination instanceof sfGuardUser)
          $destination = $destination->getId();
        
        $query->andWhere('ums.user_id = ?', $destination);
      }
      
      $query->leftJoin('mc.userMessageSettings ums')
              ->andWhere('ums.enabled > 0');
    }

    return $query->execute();
  }

  public function getMessageInfoForMultiMessage($messageCenterId = null, $messageType = null)
  {
    $query = $this->createQuery('mc')
            ->leftJoin('mc.MessageChannel mch')
            ->leftJoin('mc.messageTemplates mt')
            ->leftJoin('mc.messageCenterFiles mcf')
            ->leftJoinTranslation('mt')
            ->orderBy('mc.id ASC, mt.order ASC');

    if (!is_null($messageCenterId))
      return $query->where('mc.id = ?', $messageCenterId)->fetchOne();
    else
      return $query->where('mc.unique_name = ?', $messageType)->execute();
  }

  public function getBackendList(Doctrine_Query $query)
  {
    $rootAlias = $query->getRootAlias();

    $query->leftJoin($rootAlias . '.userMessageSettings ums WITH ums.user_id IS NULL')
            ->leftJoin($rootAlias.'.messageTemplates mt')
            ->leftJoin('mt.Translation mtt')
            ->andWhere($rootAlias . '.newsletter = ?', MessageCenter::_NO_NEWSLETTER);
    
    return $query;
  }
  
  public function getBackendNewsletterList(Doctrine_Query $query)
  {
    $rootAlias = $query->getRootAlias();

    $query->leftJoin($rootAlias.'.messageTemplates mt')
            ->leftJoin('mt.Translation mtt')
            ->andWhere($rootAlias . '.newsletter = ?', MessageCenter::_NEWSLETTER);
    
    return $query;
  }
  
  public static function getMessageCenterObject($options)
  {
    $messageCenterId = $options['id'];

    return Doctrine_Query::create()
            ->from('MessageCenter mc')
            ->leftJoin('mc.userMessageSettings ums')
            ->leftJoin('mc.Layout l')
            ->where('ums.user_id IS NULL')
            ->andWhere('mc.id = ?', $messageCenterId)->fetchOne();
  }
  
  public function getMessageCenterWithTemplates($messageCenterId)
  {
    return $this->createQuery('mc')
            ->leftJoin('mc.userMessageSettings ums')
            ->leftJoin('mc.messageTemplates mt')
            ->leftJoin('mt.Translation mtt')
            ->where('mc.id = ?', $messageCenterId)
            ->fetchOne();
  }

  public function getBaseNewsletterMessageCenter()
  {
    return $this->createQuery('mc')
            ->leftJoin('mc.messageTemplates mt')
            ->leftJoin('mt.Translation mtt')
            ->where('mc.newsletter = ?', MessageCenter::_BASE_NEWSLETTER)
            ->fetchOne();
  }
  
}