<?php

/**
 * PluginMessageMultisendList
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @package    ##PACKAGE##
 * @subpackage ##SUBPACKAGE##
 * @author     ##NAME## <##EMAIL##>
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class PluginMessageMultisendList extends BaseMessageMultisendList
{
  
  public function getEmail()
  {
    if (!is_null($this->getUserId()))
      return $this->getSfGuardUser()->getEmailAddress();
    else
      return $this->getNewsletterUser()->getNewsletterEmail();
  }

  public function getDestinationArray()
  {
    return array(
      'email' => $this->getEmail()  
    );
  }
  
  public function getSourceArray()
  {
    return array();
  }
  
  public static function getSignOutNewsletterLink($data)
  {
    sfContext::getInstance()->getConfiguration()->loadHelpers('Url');

    return ArtSimpleMessenger::removeBackend(url_for('@newsletter_signout?hash=' . self::createSignOutNewsletterHash($data), true));
  }

  public static function createSignOutNewsletterHash($newsletterUser)
  {
    $hash = md5($newsletterUser->getId() . $newsletterUser->getCreatedAt());
    $hash = substr_replace($hash, $newsletterUser->getId(), 18, 0);

    return $hash;
  }

  public static function extractSignOutNewsletterHash($hash)
  {
    $userId = substr($hash, 18, strlen($hash) - 32);

    $newsletterUser = Doctrine::getTable('NewsletterUser')->findOneById($userId);

    if ($newsletterUser !== false && self::createSignOutNewsletterHash($newsletterUser) == $hash)
      return $newsletterUser;
    else
      return false;
  }

  public static function getSignInNewsletterLink($newsletterUser)
  {
    sfContext::getInstance()->getConfiguration()->loadHelpers('Url');

    return ArtSimpleMessenger::removeBackend(url_for('@newsletter_signin?hash=' . self::createSignInNewsletterHash($newsletterUser), true));
  }
  
  public static function getSignOutTagNewsletterLink($newsletterUser)
  {
    sfContext::getInstance()->getConfiguration()->loadHelpers('Url');

    return ArtSimpleMessenger::removeBackend(url_for('@newsletter_signout_tag?hash=' . self::createSignOutTagNewsletterHash($newsletterUser).'&tag=', true));
  }
  
  public static function getTagNewsletterLink($newsletterUser)
  {
    sfContext::getInstance()->getConfiguration()->loadHelpers('Url');

    return ArtSimpleMessenger::removeBackend(url_for('@newsletter_tag?hash=' . self::createTagNewsletterHash($newsletterUser).'&tag=', true));
  }
  
  public static function getSignInTagNewsletterLink($newsletterUser)
  {
    sfContext::getInstance()->getConfiguration()->loadHelpers('Url');

    return ArtSimpleMessenger::removeBackend(url_for('@newsletter_signin_tag?hash=' . self::createSignInTagNewsletterHash($newsletterUser).'&tag=', true));
  }

  public static function createSignInNewsletterHash($newsletterUser)
  {
    $hash = md5($newsletterUser->getId() . $newsletterUser->getCreatedAt());
    $hash = substr_replace($hash, $newsletterUser->getId(), 14, 0);

    return $hash;
  }

  public static function extractSignInNewsletterHash($hash)
  {
    $userId = substr($hash, 14, strlen($hash) - 32);

    $newsletterUser = Doctrine::getTable('NewsletterUser')->findOneById($userId);

    if ($newsletterUser !== false && self::createSignInNewsletterHash($newsletterUser) == $hash)
      return $newsletterUser;
    else
      return false;
  }
  
  public static function createSignInTagNewsletterHash($newsletterUser)
  {
    $hash = md5($newsletterUser->getId() . $newsletterUser->getCreatedAt());
    $hash = substr_replace($hash, $newsletterUser->getId(), 16, 0);

    return $hash;
  }

  public static function extractSignInTagNewsletterHash($hash)
  {
    $userId = substr($hash, 16, strlen($hash) - 32);

    $newsletterUser = Doctrine::getTable('NewsletterUser')->findOneById($userId);

    if ($newsletterUser !== false && self::createSignInTagNewsletterHash($newsletterUser) == $hash)
      return $newsletterUser;
    else
      return false;
  }
  
  public static function createSignOutTagNewsletterHash($newsletterUser)
  {
    $hash = md5($newsletterUser->getId() . $newsletterUser->getCreatedAt());
    $hash = substr_replace($hash, $newsletterUser->getId(), 11, 0);

    return $hash;
  }

  public static function extractSignOutTagNewsletterHash($hash)
  {
    $userId = substr($hash, 11, strlen($hash) - 32);

    $newsletterUser = Doctrine::getTable('NewsletterUser')->findOneById($userId);

    if ($newsletterUser !== false && self::createSignOutTagNewsletterHash($newsletterUser) == $hash)
      return $newsletterUser;
    else
      return false;
  }
  
  public static function createTagNewsletterHash($newsletterUser)
  {
    $hash = md5($newsletterUser->getId() . $newsletterUser->getCreatedAt());
    $hash = substr_replace($hash, $newsletterUser->getId(), 13, 0);

    return $hash;
  }

  public static function extractTagNewsletterHash($hash)
  {
    $userId = substr($hash, 13, strlen($hash) - 32);

    $newsletterUser = Doctrine::getTable('NewsletterUser')->findOneById($userId);

    if ($newsletterUser !== false && self::createTagNewsletterHash($newsletterUser) == $hash)
      return $newsletterUser;
    else
      return false;
  }

  public static function fillListForNewsletterToAll($messageCenterId)
  {
    $typeId = Doctrine::getTable('MessageMultisendType')->findOneByName('newsletter')->getId();
    $newsletterUserActive = NewsletterUser::_ACTIVE;
    
    artQuery::executeSql("INSERT INTO message_multisend_list select null, $messageCenterId, $typeId, null, id, NOW(), NOW() FROM newsletter_user where status = '$newsletterUserActive';");
  }
  
  public static function fillListForNewsletterFromEmailList($messageCenterId, $emails)
  {
    $typeId = Doctrine::getTable('MessageMultisendType')->findOneByName('newsletter_manual')->getId();
    if (is_array($emails))
    foreach ($emails as $email)
    {
      $newsletterUser = Doctrine::getTable("NewsletterUser")->findOneByEmail($email);
      if (!$newsletterUser)
      {
        $newsletterUser = new NewsletterUser();
        $newsletterUser->setEmail($email);
        $newsletterUser->setStatus(NewsletterUser::_MANUALLY_ADDED);        
        $newsletterUser->save();
      }
      
    }
    //artQuery::executeSql("INSERT INTO message_multisend_list select null, $messageCenterId, $typeId, sgu.id , null, NOW(), NOW() FROM sf_guard_user sgu JOIN user_detail ud on sgu.id = ud.id WHERE sgu.is_active = 1 AND ud.company_id IS NOT NULL");
  }

}