<?php

/**
 * PluginMessageMultisendListTable
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 */
class PluginMessageMultisendListTable extends artDoctrineTable
{

  public static $idsToDelete = array();

  /**
   * Returns an instance of this class.
   *
   * @return object PluginMessageMultisendListTable
   */
  public static function getInstance()
  {
    return Doctrine_Core::getTable('PluginMessageMultisendList');
  }

  public function getMessageList($multisendTypeId, $sendLimit = 0)
  {
    $query = $this->createQuery('msl')
            ->where('msl.message_multisend_type_id = ?', $multisendTypeId);

    if ($sendLimit > 0)
      $query->limit($sendLimit);

    return $query->execute();
  }
/*
  public function getMessageListForNewsletter($multisendTypeId, $sendLimit)
  {
    $query = $this->createQuery('msl')
            ->innerJoin('msl.NewsletterUser nu')
            ->leftJoin('nu.sfGuardUser sgu')
            ->where('msl.message_multisend_type_id = ?', $multisendTypeId)
            ->andWhere('nu.status = ?', NewsletterUser::_ACTIVE);

    if ($sendLimit > 0)
      $query->limit($sendLimit);

    return $query->execute();
  }
*/  
   public function getMessageListForNewsletter($multisendTypeId, $sendLimit)
  {
    $query = $this->createQuery('msl')
            ->leftJoin('msl.NewsletterUser nu')
            ->leftJoin('nu.sfGuardUser sgu')
            ->where('msl.message_multisend_type_id = ?', $multisendTypeId);

            //->andWhere('nu.status = ?', NewsletterUser::_ACTIVE);

    if ($sendLimit > 0)
      $query->limit($sendLimit);

    return $query->execute();
  }


  public static function addToDeleteMessageList($messageMultisendListId)
  {
    self::$idsToDelete[] = $messageMultisendListId;
  }
  
  public function deleteMessageList()
  {
    if (!empty(self::$idsToDelete))
    {
      $this->createQuery()
              ->delete()
              ->whereIn('id', self::$idsToDelete)
              ->execute();
        self::$idsToDelete = array();
    }
  }
  
  public function countLeftMessages()
  {
    return $this->createQuery()
            ->count();
  }

}