<?php

/**
 * PluginNewsletterUser
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @package    ##PACKAGE##
 * @subpackage ##SUBPACKAGE##
 * @author     ##NAME## <##EMAIL##>
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class PluginNewsletterUser extends BaseNewsletterUser
{
  const _INACTIVE = 0;
  const _ACTIVE = 1;
  const _EMAIL_FROM_DATABASE = 2;
  const _EMAIL_FROM_MANUAL = 3;
  const _EMAIL_FROM_DATABASE_SENDING = 4;
  const _EMAIL_FROM_MANUAL_SENDING = 5;

  public static function getCSVPath()
  {
    return 'uploads/file.csv';
  }

  public function __toString()
  {
    return $this->getNewsletterFirstName() . ' ' . $this->getNewsletterLastName() . ' (' . $this->getNewsletterEmail() . ')';
  }

  public static function createCSVFile($ids = array())
  {
    sfContext::getInstance()->getConfiguration()->loadHelpers(array('I18N'));
    $newsletterUsers = Doctrine::getTable('NewsletterUser')->getUsers($ids);

    $fp = fopen(self::getCSVPath(), 'w');

    $fieldsNames = array(
        'Id',
        'Email',
        __('Imie'),
        __('Nazwisko'),
        __('Nazwa statusu'),
    );

    fputcsv($fp, $fieldsNames);
    fputcsv($fp, array());

    foreach ($newsletterUsers as $i => $newsletterUser)
    {
      $fields = array(
          $newsletterUser->getId(),
          $newsletterUser->getNewsletterEmail(),
          $newsletterUser->getNewsletterFirstName(),
          $newsletterUser->getNewsletterLastName(),
          $newsletterUser->getStatusName()
      );

      fputcsv($fp, $fields);
    }

    fclose($fp);
  }

  public static function getStatusKeys()
  {
    sfContext::getInstance()->getConfiguration()->loadHelpers(array('I18N'));

    return array(
        self::_INACTIVE => __('Niaktywny'),
        self::_ACTIVE => __('Aktywny'),
        self::_EMAIL_FROM_MANUAL => __('Ręcznie dodany'),
        self::_EMAIL_FROM_DATABASE => __('Dodany z bazy danych'),
        self::_EMAIL_FROM_DATABASE_SENDING => __('Z bazy danych - Wysyłanie'),
        self::_EMAIL_FROM_MANUAL_SENDING => __('Ręcznie dodany - Wysyłanie'),
      );
  }

  public function getStatusName($status = null)
  {
    if (is_null($status))
      $status = $this->getStatus();

    return artArray::getFromArray(self::getStatusKeys(), $status, '');
  }

  public function getNewsletterEmail()
  {
    if ($this->getIsRegistered())
      return $this->getSfGuardUser()->getEmailAddress();
    else
      return $this->getEmail();
  }

  public function getNewsletterFirstName()
  {
    if ($this->getIsRegistered())
      return $this->getSfGuardUser()->getFirstName();
    else
      return $this->getFirstName();
  }

  public function getNewsletterLastName()
  {
    if ($this->getIsRegistered())
      return $this->getSfGuardUser()->getLastName();
    else
      return $this->getLastName();
  }

  public function getIsRegistered()
  {
    return $this->getSfGuardUser() && !$this->getSfGuardUser()->isNew();
  }

  public static function createObjectWithUserId($userId)
  {
    $object = new NewsletterUser();
    $object->setUserId($userId);
    $object->setStatus(NewsletterUser::_ACTIVE);
    $object->save();
    
    return $object;
  }

}