<?php

/**
 * PluginUserMessageSetting
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @package    ##PACKAGE##
 * @subpackage ##SUBPACKAGE##
 * @author     ##NAME## <##EMAIL##>
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class PluginUserMessageSetting extends BaseUserMessageSetting
{

  public static function updateUserMessageSettings($userId)
  {
    $defaultsSettings = Doctrine::getTable('UserMessageSetting')->getSettings();
    $userSettings = Doctrine::getTable('UserMessageSetting')->getSettings($userId);

    if ($userSettings->count() != $defaultsSettings->count())
    {
      $processDefaultsSettings = self::processUserMessageSettings($defaultsSettings);
      $processUserSettings = self::processUserMessageSettings($userSettings);

      foreach ($processDefaultsSettings as $messageCenterId => $enabled)
        if (!isset($processUserSettings[$messageCenterId]))
          self::newRecord($userId, $messageCenterId, (bool)$enabled);
    }
  }

  public static function setUserMessageSettings($userId)
  {
    $defaultsSettings = Doctrine::getTable('UserMessageSetting')->getSettings();
    $processDefaultsSettings = self::processUserMessageSettings($defaultsSettings);

    foreach ($processDefaultsSettings as $messageCenterId => $enabled)
      self::newRecord($userId, $messageCenterId, (bool)$enabled);
  }

  public static function processUserMessageSettings($userMessageSettings)
  {
    $newUserMessageSettings = array();

    foreach ($userMessageSettings as $userMessageSetting)
      $newUserMessageSettings[$userMessageSetting->getMessageCenterId()] = $userMessageSetting->getEnabled();

    return $newUserMessageSettings;
  }

  public static function newRecord($userId, $messageCenterId, $enabled)
  {
    $messageCenter = new UserMessageSetting();
    $messageCenter->setUserId($userId);
    $messageCenter->setMessageCenterId($messageCenterId);
    $messageCenter->setEnabled($enabled);
    $messageCenter->save();

    return $messageCenter;
  }

}