<?php

/**
 * Description of MessengerSettings
 *
 */
class MessengerSettings {

  private static $options = array(
      'tags' => '40787f241349515676286cc360868494',
  );
  
  private static $config = null;

  private static function readAndDecode() {
    if (empty(self::$config))
      self::$config = parse_ini_file(sfConfig::get('sf_config_dir') . '/messenger_config.ini');
  }

  public static function has($option) {
    self::readAndDecode();

    return (isset(self::$config[$option]) && self::$config[$option] == self::$options[$option]);
  }

  public static function hasTags() {
    return self::has('tags');
  }

  
}
