<?php

/**
 * Description of PluginPaNewsletterUserTabFormConfiguration
 *
 
 */
class PluginPaMessageCenterTabFormConfiguration extends BaseTabFormConfiguration
{

  protected $withOrder = true;
  protected $configuration = array(
      'NewsletterSettingsTab' => array(
          'form_class' => 'MessageCenterForm',
          'foreign_key_name' => 'id',
          'doctrine_object_class' => 'MessageCenter',
          'order' => 1
      ),
  );

  public function __construct(artTabActions $actionsObject)
  {
    parent::__construct($actionsObject);
    
    $messageCenterId = $this->request->getParameter('id');
    $messageTemplates = Doctrine::getTable('MessageTemplate')->getTemplatesForMessageCenter($messageCenterId);
    
    foreach ($messageTemplates as $messageTemplate)
    {
      $this->configuration['MessageTemplateTab' . $messageTemplate->getId()] = array(
          'tab_i18n_name' => 'MessageTemplateTab %1%',
          'tab_i18n_params' => array('%1%' => $messageTemplate->getOrder()),
          'form_class' => 'MessageTemplateForm',
          'foreign_key_name' => 'message_template_id' . $messageTemplate->getId(),
          'doctrine_object_class' => 'MessageTemplate',
          'order' => $messageTemplate->getOrder() + 5
      );
    }
    
    $this->setTabsInOrder();
  }
  
  public function getForeignKeyForTab()
  {
    $foreignKeyName = $this->configuration[$this->tabName]['foreign_key_name'];

    if (artString::startsWith('MessageTemplateTab', $this->tabName))
      return str_replace('MessageTemplateTab', '', $this->tabName);
    else    
      return $this->request->getParameter($foreignKeyName, null);
  }

}
