<?php

/**
 * Description of PluginPaNewsletterUserTabFormConfiguration
 *
 
 */
class PluginPaNewsletterTabFormConfiguration extends BaseTabFormConfiguration
{

  protected $withOrder = true;
  protected $configuration = array(
      'TestSendTab' => array(
          'foreign_key_name' => 'id', // fake_id
          'form_class' => 'TestSendForm',
          'submit_form_on_change_tab' => false,
          'tab_submit_name' => 'Send',
          'order' => 1001
      ),
      'SendToAllTab' => array(
          'foreign_key_name' => 'id', // fake_id
          'form_class' => 'SendToAllForm',
          'submit_form_on_change_tab' => false,
          'tab_submit_name' => 'Send',
          'order' => 1002
      ),
      'SendToEmailAddresses' => array(
          'foreign_key_name' => 'id', // fake_id
          'form_class' => 'SendToEmailAddressesForm',
          'submit_form_on_change_tab' => false,
          'tab_submit_name' => 'Send',
          'order' => 10010)
  );

  public function __construct(artTabActions $actionsObject)
  {
    parent::__construct($actionsObject);
    
    $messageCenterId = $this->request->getParameter('id');
    $messageTemplates = Doctrine::getTable('MessageTemplate')->getTemplatesForMessageCenter($messageCenterId);
    
    foreach ($messageTemplates as $messageTemplate)
    {
      $this->configuration['MessageTemplateTab' . $messageTemplate->getId()] = array(
          'tab_i18n_name' => 'MessageTemplateTab %1%',
          'tab_i18n_params' => array('%1%' => $messageTemplate->getOrder()),
          'form_class' => 'PluginNewsletterMessageTemplateForm',
          'foreign_key_name' => 'message_template_id' . $messageTemplate->getId(),
          'doctrine_object_class' => 'MessageTemplate',
          'order' => $messageTemplate->getOrder() + 5
      );
    }
    
    $this->setTabsInOrder();
  }
  
  public function getForeignKeyForTab()
  {
    $foreignKeyName = $this->configuration[$this->tabName]['foreign_key_name'];

    if (artString::startsWith('MessageTemplateTab', $this->tabName))
      return str_replace('MessageTemplateTab', '', $this->tabName);
    else    
      return $this->request->getParameter($foreignKeyName, null);
  }

}
