<?php
/**
 * Description of artMessageCenterUpdate
 */
class arteneoMessageCenterUpdateTask extends sfBaseTask
{
  protected $messageCenterTables = array();
  
  protected function configure()
  {
    
    $this->namespace        = 'arteneo';
    $this->name             = 'update-msg-center';
    $this->briefDescription = 'Updates data in message center';
    $this->detailedDescription = <<<EOF
The [arteneo:update-msg-center|INFO] task does things.
Call it with:

  [php symfony arteneo:update-msg-center|INFO]
EOF;
  }
  
  protected function execute($arguments = array(), $options = array())
  {
    $this->messageCenterTables = array(
        'message_channel',
        'message_center',
        'user_message_settings',
        'template_message',
        'template_message_translation'
    );
    
    $dbh = $this->openDbConnection($options);
    $this->truncateMessageCenterDb($dbh);
    $this->runTask('doctrine:data-load --append /plugins/artMessengerPlugin/data/fixtures/fixtures_msg.yml');
    $this->closeDbConnection($dbh);
  }
  
  protected function truncateMessageCenterDb($dbh)
  {
    foreach($this->messageCenterTables as $table)
    {
      artDebug::var_dump($table);
        $dbh->query('TRUNCATE TABLE '. $table);      
    }    
  }
}
