<?php
/**
 * Description of artMessageCenterUpdate
 */
class artMessageCenterUpdate extends arteneoDataLoadTask
{
  protected $messageCenterTables = array();
  
  protected function configure()
  {
    $this->addOptions(array(
      new sfCommandOption('connection', null, sfCommandOption::PARAMETER_REQUIRED, 'The connection name', 'doctrine'),
    ));
    $this->namespace        = 'arteneo';
    $this->name             = 'update-msg-center';
    $this->briefDescription = 'Updates data in message center';
    $this->detailedDescription = <<<EOF
The [arteneo:update-msg-center|INFO] task does things.
Call it with:

  [php symfony arteneo:update-msg-center|INFO]
EOF;
  }
  
  protected function execute($arguments = array(), $options = array())
  {
    $this->messageCenterTables = array(
        'message_channel',
        'message_center',
        'user_message_settings',
        'message_template',
        'message_template_translation'
    );
    
    $dbh = $this->openDbConnection($options);
    $this->truncateMessageCenterDb($dbh);
    $this->runTask('doctrine:data-load', array('plugins/artMessengerPlugin/data/fixtures/fixtures_msg.yml'), array('append'));
    $this->closeDbConnection($dbh);
  }
  
  protected function truncateMessageCenterDb($dbh)
  {
    foreach($this->messageCenterTables as $table)
    {
      artDebug::var_dump($table);
        $dbh->query('TRUNCATE TABLE '. $table);      
    }    
  }
}
