<?php

class Plugininternal_categoryActions extends artActions
{

  public function preExecute()
  {
    $this->setLayout(sfConfig::get('app_art_messenger_plugin_internal_message_layout', 'empty_layout'));

    parent::preExecute();
  }

  public function executeEditCategory(sfWebRequest $request)
  {
    $this->categoryId = $request->getParameter('internal_category_id', null);

    if (is_int(intval($this->categoryId)))
    {
      $category = Doctrine::getTable('InternalCategory')->find($this->categoryId);

      if ($category && $category->isUserCategory($this->getUser()->getId()))
      {
        $this->form = new AjaxInternalCategoryForm($category);

        if ($request->isMethod('post') && $request->hasParameter($this->form->getName()))
        {
          $this->form->bind($request->getParameter($this->form->getName()));

          if ($this->form->isValid())
          {
            $category = $this->form->save();
            $this->categoryName = $category->getName();
          }
        }

        return 'Success';
      }
    }

    $this->setError();

    return sfView::NONE;
  }

  public function executeNewCategory(sfWebRequest $request)
  {
    $form = new AjaxInternalCategoryForm();

    if ($request->isMethod('post') && $request->hasParameter($form->getName()))
    {
      $form->bind($request->getParameter($form->getName()));

      if ($form->isValid())
        $form->save();
    }

    return sfView::NONE;
  }

  public function executeDeleteCategory(sfWebRequest $request)
  {
    $categoryId = $request->getParameter('internal_category_id', null);

    if (is_int(intval($categoryId)))
    {
      $category = Doctrine::getTable('InternalCategory')->find($categoryId);

      if ($category->isUserCategory($this->getUser()->getId()))
      {
        $category->delete();
        $this->getUser()->setFlash('notice', 'Katalog usunięty pomyślnie.');

        return $this->renderText('ok');
      }
    }

    $this->setError();

    return sfView::NONE;
  }

  protected function setError()
  {
    $this->getUser()->setFlash('error', 'Wystąpił błąd. Proszę spróbowac ponownie.');
  }

}