<?php

require_once dirname(__FILE__) . '/../lib/internal_messageGeneratorConfiguration.class.php';
require_once dirname(__FILE__) . '/../lib/internal_messageGeneratorHelper.class.php';

/**
 * internal_message actions.
 *
 * @package    testmcs
 * @subpackage internal_message
 * @author     Your name here
 * @version    SVN: $Id: actions.class.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class Plugininternal_messageActions extends autoInternal_messageActions
{

  public function preExecute()
  {
    if (sfContext::getInstance()->getActionName() == 'inbox')
      $this->setLayout(sfConfig::get('app_art_messenger_plugin_internal_message_inbox_layout', 'layout'));
    else
      $this->setLayout(sfConfig::get('app_internal_message_layout', 'empty_layout'));

    parent::preExecute();
  }
 
  public function executeIndex(sfWebRequest $request)
  {
    $filterDefaults = $this->configuration->getFilterDefaults();
    
    if (!$this->hasFilters() && !empty($filterDefaults))
      $this->executeFilter($request);
      
    if ($request->getParameter('sort') && $this->isValidSortColumn($request->getParameter('sort')))
      $this->setSort(array($request->getParameter('sort'), $request->getParameter('sort_type')));

    if ($request->getParameter('page'))
      $this->setPage($request->getParameter('page'));

    $this->pager = $this->getPager();
    $this->sort = $this->getSort();
  }

  public function executeInbox(sfWebRequest $request)
  {
    $this->userHaveOwnCategories = InternalCategory::userHaveOwnCategories($this->getUser()->getId());
    $this->categories = Doctrine::getTable('InternalCategory')->getUserCategoriesWithoutArchive();
    $this->defaultInternalCategoryId = sfConfig::get('app_art_messenger_plugin_internal_messages_default_category', InternalCategory::INBOX_ID);
    $this->getUser()->setAttribute('internal_category_id', $this->defaultInternalCategoryId, 'internal_messages');
  }

  public function executeGetMessagesForCategory(sfWebRequest $request)
  {
    $this->getUser()->setAttribute('internal_category_id', $request->getParameter('category_id', 0), 'internal_messages');
    $this->setPage(1);
    $this->setList($request);
  }

  public function executeGetUserCategories(sfWebRequest $request)
  {
    $this->form = new UserCategoriesForm();

    return $this->renderText($this->form->__toString());
  }

  public function executeChangePage(sfWebRequest $request)
  {
    $this->setPage($request->getParameter('page'));
    $this->setList($request);
  }
  
  public function executeAjaxSorting(sfWebRequest $request)
  {
    $this->setList($request);
  }  

  public function setList(sfWebRequest $request)
  {
    $this->userHaveOwnCategories = InternalCategory::userHaveOwnCategories($this->getUser()->getId());
    $this->executeIndex($request);
    $this->setTemplate('list');
  }

  public function executeShow(sfWebRequest $request)
  {
    $this->message = Doctrine::getTable('InternalMessage')->find($request->getParameter('id'));
  }

  protected function processForm(sfWebRequest $request, sfForm $form)
  {
    $form->bind($request->getParameter($form->getName()), $request->getFiles($form->getName()));

    if ($form->isValid())
    {
      try
      {
        $internal_message = $form->save();
      }
      catch (Doctrine_Validator_Exception $e)
      {
        $errorStack = $form->getObject()->getErrorStack();
        $message = get_class($form->getObject()) . ' has ' . count($errorStack) . " field" . (count($errorStack) > 1 ? 's' : null) . " with validation errors: ";

        foreach ($errorStack as $field => $errors)
          $message .= "$field (" . implode(", ", $errors) . "), ";

        $message = trim($message, ', ');
        $this->getUser()->setFlash('error', $message);

        return sfView::SUCCESS;
      }

      $this->dispatcher->notify(new sfEvent($this, 'admin.save_object', array('object' => $internal_message)));
      $this->getUser()->setFlash('notice', 'Wiadomość została wysłana pomyślnie.');

      $this->redirect('@inbox_category?category_id=' . $this->getSessionCategoryId());
    }
    else
      $this->getUser()->setFlash('error', 'Wiadomość nie została wysłana ze względu na błędy.', false);
  }

  public function executeBatch(sfWebRequest $request)
  {
    $request->checkCSRFProtection();
    $user = $this->getUser();

    if (!$ids = $request->getParameter('ids'))
      $user->setFlash('error', 'Musisz wybrać co najmniej jeden element.');

    if (!$action = $request->getParameter('batch_action'))
      $user->setFlash('error', 'Wybierz akcje aby ją wykonać na zaznaczonych elementach.');

    if (!method_exists($this, $method = 'execute' . ucfirst($action)))
      throw new InvalidArgumentException(sprintf('You must create a "%s" method for action "%s"', $method, $action));

    if (!$user->hasCredential($this->configuration->getCredentials($action)))
      $this->forward(sfConfig::get('sf_secure_module'), sfConfig::get('sf_secure_action'));

    try
    {
      $validator = new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'InternalMessage'));
      $ids = $validator->clean($ids);
      $this->messagesIds = $request->getParameter('ids');
      $this->userId = $this->getUser()->getId();
      $this->$method($request);
    }
    catch (sfValidatorError $e)
    {
      $user->setFlash('error', 'Wystąpił problem, ponieważ część z zaznaczonych rekordów nie istnieje.');
    }
    
    $this->setList($request);
  }

  protected function executeBatchMoveToCategories(sfWebRequest $request)
  {
    $userCategories = $request->getParameter('user_categories_widget', null);
    $oldCategoryId = $this->getSessionCategoryId();

    if (InternalMessageCategory::moveToCategories($this->userId, $this->messagesIds, $userCategories, $oldCategoryId))
      $this->getUser()->setFlash('notice', 'Wiadomości zostały przeniesione do wybranych kategorii pomyślnie.');
    else
      $this->setError();
  }

  protected function executeBatchAddToCategories(sfWebRequest $request)
  {
    $userCategories = $request->getParameter('user_categories_widget', null);

    if (InternalMessageCategory::addToCategories($this->userId, $this->messagesIds, $userCategories))
      $this->getUser()->setFlash('notice', 'Wiadomości zostały dodane do wybranych kategorii pomyślnie.');
    else
      $this->setError();
  }

  protected function executeBatchMoveToTrash(sfWebRequest $request)
  {
    if (InternalMessage::moveToTrash($request, $this->messagesIds))
      $this->getUser()->setFlash('notice', 'Wiadomości zostały przeniesione do kosza pomyślnie.');
    else
      $this->setError();
  }

  protected function executeBatchDeleteCompletely(sfWebRequest $request)
  {
    if (InternalMessage::deleteCompletely($request, $this->messagesIds))
      $this->getUser()->setFlash('notice', 'Wiadomości zostały usunięte pomyślnie.');
    else
      $this->setError();
  }

  public function executeMoveToTrash(sfWebRequest $request)
  {
    if (InternalMessage::moveToTrash($request, array($request->getParameter('id'))))
      $this->getUser()->setFlash('notice', 'Wiadomość została przeniesiona do kosza pomyślnie.');
    else
      $this->setError();

    $this->setList($request);
  }

  public function executeDeleteCompletely(sfWebRequest $request)
  {
    if (InternalMessage::deleteCompletely($request, array($request->getParameter('id'))))
      $this->getUser()->setFlash('notice', 'Wiadomość została usunięta pomyślnie.');
    else
      $this->setError();

    $this->setList($request);
  }
  
  protected function getSessionCategoryId()
  {
    return $this->getUser()->getAttribute('internal_category_id', null, 'internal_messages');
  }

  protected function setError()
  {
    $this->getUser()->setFlash('error', 'Wystąpił błąd. Proszę spróbowac ponownie.');
  }
}