<?php use_stylesheet('/arteneo-theme/css/jquery.multiselect.css') ?>

<script type="text/javascript">
  var internalMessageCategoriesWidth = '';
  var withDelete = false;
  
  $(document).ready(function(){
    setCategoriesPanel(); <?php /* ustaw szerokość paska kategorii oraz widoczność przycisków do przesuwania */ ?>
    $('.internal-message-category-actions select option:first').attr('selected', 'selected'); <?php /* zaznacz "wybierz akcję" */ ?>
<?php /* ustawienie szerokości paska kategorii -> można ustawić w app.yml, domyślnie jest to 600px */ ?>
    $('#internal-message-box').width(<?php echo sfConfig::get('app_art_messenger_plugin_inbox_category_categories_width', 600) ?>);
    
<?php /* funkcja wywoływana po kliknięciu na edycję nazwy katalogu -> wywołuje ajaxa z formularzem edycji inline */ ?>
    $('.internal-message-category-edit').live('click', function() {
      var element = $(this);
      var categoryId = element.parent().find('.internal-message-category-id').html();
      
      $.ajax({
        type:'POST',
        dataType:'html',
        success:function(data, textStatus){
          element.parent().html(data);
          setCategoriesPanel();
        },
        beforeSend:function(XMLHttpRequest){
          element.artIndicator({position: '', view: '1'});
        },
        url: '<?php echo url_for('@inbox_edit_category') ?>?internal_category_id=' + categoryId
      }); 
    });
    
<?php /* funkcja wywoływana po kliknięciu na usunięcie katalogu -> ajax usuwa katalog i później zostaje przeładowana strona*/ ?>
    $('.internal-message-category-delete').live('click', function() {
      var element = $(this);
      var categoryId = element.parent().find('.internal-message-category-id').html();
      
      $.ajax({
        type:'POST',
        dataType:'html',
        success:function(data, textStatus){
          location.reload();
        },
        beforeSend:function(XMLHttpRequest){
          element.artIndicator({position: '', view: '1'});
        },
        url: '<?php echo url_for('@inbox_delete_category') ?>?internal_category_id=' + categoryId
      }); 
    });
  })
  
  function deleteNotice(){
    $('.notice').remove();
  }
  
<?php /* funkcja odpalana podczas ładowania listy wiadomości */ ?>
  function loadingMessages(){
    deleteNotice();
    $("#internal-message-list").artIndicator({position: '', view: '1'}); 
  }

<?php /* funkcja odpalana za pojawienie się załadowanej listy wiadomośći */ ?>
  function successMessages(data){
    $("#internal-message-list").fadeIn(300);
    $("#internal-message-list").html(data);
  }

<?php /* funkcja wywoływana podczas zmiany strony */ ?>
  function paginationChangePage(_url)
  {
    $.ajax({
      type:'POST',
      dataType:'html',
      success:function(data, textStatus){
        successMessages(data);
      },
      beforeSend:function(XMLHttpRequest){
        loadingMessages()
      },
      url: _url
    }); 
    return false;
  }
  
<?php /* funkcja uruchamiana podczas przesuwania paska kategorii w lewo */ ?>
  function moveBoxLeft(){
    boxLeft = parseInt($('#internal-message-categories').css('left'),10); <?php /* nie wiedziałem jak nazwać zmienną:) */ ?>

<?php /* generalnie chodzi o to, że jeżeli z z lewej strony jest więcej niż 50px do przesunięcia, to 
 * panel przesuwa się w lewo o 100px; jeżeli mniej niż 50, ale więcej niż 0, to o 50px */ ?>
    if(boxLeft+50<0)
      $('#internal-message-categories').animate({
        left: '+=100'
      },200);
    else if (boxLeft<0)
      $('#internal-message-categories').animate({
        left: '+=50'
      },100);
  }
  
<?php /* funkcja uruchamiana podczas przesuwania paska kategorii w prawo */ ?>
  function moveBoxRight(){
    $('#internal-message-categories').animate({
         left: '-=0'
       },0);  <?php /* ie fix by Piotrek */ ?>
      
<?php /* nie wiedziałem jak nazwać zmienne:) */ ?>
      boxWidth = parseInt($('#internal-message-categories').width(),10);
      outboxWidth = (parseInt($("#internal-message-categories-outbox").width(), 10))-(parseInt($('#internal-message-categories').css('left'),10));
      
<?php /* generalnie chodzi o to, że jeżeli z z prawej strony jest więcej niż 50px do przesunięcia, to 
 * panel przesuwa się w prawo o 100px; jeżeli mniej niż 50, ale więcej niż 0, to o 50px */?>
      if(boxWidth+50>outboxWidth)
         $('#internal-message-categories').animate({
            left: '-=100'
         },200);
      else if(boxWidth>outboxWidth)
         $('#internal-message-categories').animate({
            left: '-=50'
         },100);
  }
  
<?php /* funkcja służąca do ustawiania odpowiedniej szerokości paska z kategoriami */ ?>
  function setCategoriesPanel(){
  <?php /* sumowanie szerokości kategorii */ ?>
    var sum = 0;
    $(".internal-message-category").each(function(){
      sum+=$(this).outerWidth();
    })

<?php /* oraz dodanie szerokości przycisków do przesuwania panelu w prawo i lewo */ ?>
    sum = sum+$("#internal-message-box-move-left").width()+$("#internal-message-box-move-right").width();
    
    $('#internal-message-categories').width(sum);
<?php /* ustawienie szerokości paska kategorii -> można ustawić w app.yml, domyślnie jest to 600px */ ?>
    categoryPanelWidth = <?php echo sfConfig::get('app_art_messenger_plugin_inbox_category_categories_width', 600) ?>;
    
  <?php /* jeżeli suma szerokości kategorii jest większa niż szerokość panelu, 
   * który jest pokazywany, to pokaż przyciski do przesuwania w prawo i lewo */ ?>
    if (sum > categoryPanelWidth){
//      $("#internal-message-categories-outbox").css('overflow', 'relative');
      $("#internal-message-box-move-right").removeClass('art-hide');
      $("#internal-message-box-move-left").removeClass('art-hide');
      newWidth = categoryPanelWidth - ($("#internal-message-box-move-left").outerWidth()+$("#internal-message-box-move-right").outerWidth());
      $("#internal-message-categories-outbox").width(newWidth);
    }
    else{ <?php /* w przeciwnym wypadku ukryj przyciski do przesuwania w prawo i lewo */ ?>
      $("#internal-message-box-move-right").addClass('art-hide');
      $("#internal-message-box-move-left").addClass('art-hide');
      $("#internal-message-categories-outbox").width(categoryPanelWidth);
//      $("#internal-message-categories-outbox").css('overflow', 'visible');
    }
  }

<?php /* ukrywanie multicheckboxa do wybierania kategorii usera, do których można przenieść wiadomości */ ?>
  function hideUserCategories()
  {
    $("#internal-message-user-categories").fadeOut(300);
    $("#internal-message-user-categories").html("");
  }
    
<?php /* pobieranie multicheckboxa do wybierania kategorii usera, do których można przenieść wiadomości */ ?>
  function getUserCategories()
  {
    $.ajax({
      type:'POST',
      dataType:'html',
      success:function(data, textStatus){
        $("#internal-message-user-categories").artIndicatorClose();
        $("#internal-message-user-categories").hide();
        $("#internal-message-user-categories").fadeIn(500);
        $("#internal-message-user-categories").html(data);
      },
      beforeSend:function(XMLHttpRequest){
        $("#internal-message-user-categories").artIndicator({position: '', view: '1'}); 
      },
      url: '<?php echo url_for('@internal_message_user_categories') ?>'
    }); 
  }

<?php /* dodanie divów, za pomocą których mozna usunąć kategorię */ ?>
  function addDeleteCatalogsDivs(){
    $(".internal-message-category form").each(function(){
      $(this).submit();
    })
    resetCatalogs();
    withDelete = true;
    $(".internal-message-category-user .box_center").each(function(){
      $(this).append('<div class="internal-message-category-delete"></div>');
    })
    setCategoriesPanel();
  }

<?php /* dodanie divów, za pomocą których mozna edytować nazwę kategorii */ ?>
  function addEditCatalogsDivs(){
    resetCatalogs();
    $(".internal-message-category-user .box_center").each(function(){
      $(this).append('<div class="internal-message-category-edit"></div>');
    })
    setCategoriesPanel();
  }
  
<?php /* funkcja służąca do usuwania możliwości edycji/usuwania kategorii oraz formularza dodawania kategorii */ ?>
function resetCatalogs(){
  withDelete = false;
  deleteNotice();
  $('.internal-message-category-edit').remove();
  $('.internal-message-category-delete').remove();
  $('.internal-message-category-new').fadeOut(300);
}
  
<?php /* funkcja pokazuje formularz dodawania nowej kategorii */ ?>
function addUserCatalog(){
  resetCatalogs();
  $('#internal-message-categories').animate({
        left: '0'
      },200);
  $('.internal-message-category-new').fadeIn(300);
}
  
function loadingNewInternalCategory(){
  $('.internal-message-category-new-indicator').artIndicator({position: '', view: '1'}); 
  $('.internal-message-category-new-submit').remove();
}
  
<?php /* zmiana aktywnej kategorii, wywoływana po kliknięciu na konkretną kategorię */ ?>
function changeActiveClass(categoryId)
{
  $(".internal-message-category-active").removeClass('internal-message-category-active');
  $("#internal-message-category-"+categoryId).addClass('internal-message-category-active');
  setCategoriesPanel();
}

function batchSubmit(){
  if ($("#internal-message-batch-action option:selected").val() == 'batchDeleteCompletely')
    return confirm('<?php echo __('Czy na pewno?')?>');
  else
    return true;
}
</script>