<?php
/**
 * Newsletter actions.
 */

class PluginnewsletterActions extends artActions {

  public function executeNewsletterSignOut(sfWebRequest $request) {
    $hash = $request->getParameter('hash');

    if (!isset($hash))
      $this->getUser()->setError('Nieprawidłowy link.');
    else {
      $newsletterUser = MessageMultisendList::extractSignOutNewsletterHash($hash);

      if (!$newsletterUser)
        $this->getUser()->setError('Nieprawidłowy link.');
      else {
        $newsletterUser->delete();
        $this->getUser()->setNotice('Twój adres email został usunięty z naszej bazy danych.');
      }
    }

    $this->redirect(Redirector::get('Messenger_NewsletterSignOut',array('request' => $request )));
  }

  public function executeNewsletterSignIn(sfWebRequest $request){
    $hash = $request->getParameter('hash');

    if (!isset($hash))
      $this->getUser()->setError('Nieprawidłowy link.');
    else {
      $newsletterUser = MessageMultisendList::extractSignInNewsletterHash($hash);

      if ($newsletterUser && $newsletterUser->getStatus() == NewsletterUser::_INACTIVE) {
        $newsletterUser->setStatus(NewsletterUser::_ACTIVE);
        $newsletterUser->save();
        $this->getUser()->setNotice('Twój adres email został dodany do naszej bazy danych.');
      }
      else
        $this->getUser()->setError('Nieprawidłowy link.');
    }

    $this->redirect(Redirector::get('Messenger_NewsletterSignIn',array('request' => $request )));
  }
  
  public function executeNewsletterSignInTag(sfWebRequest $request){
    $hash = $request->getParameter('hash');

    if (!isset($hash))
      $this->getUser()->setError('Nieprawidłowy link.');
    else {
      $newsletterUser = MessageMultisendList::extractSignInTagNewsletterHash($hash);

      if ($newsletterUser && $newsletterUser->getStatus() == NewsletterUser::_INACTIVE) {
        $newsletterUser->setStatus(NewsletterUser::_ACTIVE);
        $newsletterUser->save();
        
        $tag = $request->getParameter('tag');
        
        if (isset($tag))
          UserTag::addTagNewsletterUser($tag, $newsletterUser);
        
        $this->getUser()->setNotice('Twój adres email został dodany do naszej bazy danych.');
      }
      else
        $this->getUser()->setError('Nieprawidłowy link.');
    }

    $this->redirect(Redirector::get('Messenger_NewsletterSignInTag',array('request' => $request )));
  }
  
  public function executeNewsletterSignOutTag(sfWebRequest $request) {
    $hash = $request->getParameter('hash');

    if (!isset($hash))
      $this->getUser()->setError('Nieprawidłowy link.');
    else {
      $newsletterUser = MessageMultisendList::extractSignOutTagNewsletterHash($hash);

      if (!$newsletterUser)
        $this->getUser()->setError('Nieprawidłowy link.');
      else {
        $tag = $request->getParameter('tag');
        
        if (isset($tag))
          UserTag::addTagNewsletterUser($tag, $newsletterUser);
        
        $newsletterUser->delete();
        $this->getUser()->setNotice('Twój adres email został usunięty z naszej bazy danych.');
      }
    }

    $this->redirect(Redirector::get('Messenger_NewsletterSignOutTag',array('request' => $request )));
  }
  
  public function executeNewsletterTag(sfWebRequest $request) {
    $hash = $request->getParameter('hash');

    if (!isset($hash))
      $this->getUser()->setError('Nieprawidłowy link.');
    else {
      $newsletterUser = MessageMultisendList::extractTagNewsletterHash($hash);

      if (!$newsletterUser)
        $this->getUser()->setError('Nieprawidłowy link.');
      else {
        $tag = $request->getParameter('tag');
        
        if (isset($tag))
          UserTag::addTagNewsletterUser($tag, $newsletterUser);
        
        $this->getUser()->setNotice('Twój adres email został zapisany.');
      }
    }

    $this->redirect(Redirector::get('Messenger_NewsletterTag',array('request' => $request )));
  }
  
    public function executeAddUserNewsletter(sfWebRequest $request) {
    $this->form = new PluginAddUserNewsletter();

    if ($request->isMethod('post') && $request->hasParameter($this->form->getName())) {
      $this->form->bind($request->getParameter($this->form->getName()));

      if ($this->form->isValid()) {
        $form = $this->form->getValues();
        $email = $form['email'];
        $newsletterUser = new NewsletterUser();
        $newsletterUser->setId(0);
        $newsletterUser->setEmail($email);
        $newsletterUser->save();

        ArtSimpleMessenger::sendActivateNewsletterMessage($newsletterUser, array('email' => $email));

        $this->getUser()->setNotice('Zapisano adres do bazy danych i wysłano wiadomość aktywacyjną.');
        $this->forward('default', 'index');
      } else {
        $this->getUser()->setError('Wystąpił błąd. Podany adres istnieje w bazie danych lub jest niepoprawny.');
        $this->forward('default', 'index');
      }
    }
    $this->getUser()->setError('Wystąpił błąd. Podany adres istnieje w bazie danych lub jest niepoprawny.');
    $this->forward('default', 'index');
  }
  
}
