  public function executeFilter(sfWebRequest $request)
  {
    $this->setPage(1);
    $this->request = $request;
    
    if ($request->hasParameter('_reset'))
    {
      $this->setFilters(array());

      if ($request->isXmlHttpRequest())
        $this->forward('<?php echo $this->getModuleName() ?>', 'index');
      //else
        //$this->redirect('@<?php echo $this->getUrlForAction('list') ?>');
    }

    $this->filters = $this->configuration->getFilterForm($this->getFilters());

    if ($request->hasParameter($this->filters->getName()))
      $filterValues = $request->getParameter($this->filters->getName());
    else
    {
      unset($this->filters['_csrf_token']);
      $filterValues = $this->configuration->getFilterDefaults();
    }
   
    $filterValues = array_merge($this->getFilterArrayForParam($this->getFilterParam()), $filterValues);
    $this->filters->bind($filterValues);
    
    if ($this->filters->isValid())
    {
      $this->setFilters($this->filters->getValues());
      
      
      if ($this->getFilterParam() != ' ' && !$request->hasParameter('_reset'))
      {
        $this->setFilterParam(' ');
        $this->setFilters($this->filters->getValues());
      }
      
      if ($request->isXmlHttpRequest())
        $this->forward('<?php echo $this->getModuleName() ?>', 'index');
      else
        $this->redirect('@<?php echo $this->getUrlForAction('list') ?>');
    }

    $this->pager = $this->getPager();
    $this->sort = $this->getSort();

    $this->setTemplate('index');
  }

  public function executeLinkFilter(sfWebRequest $request)
  {
    $this->request = $request;
    $param = $request->getParameter('param', false);
    if ($param)
    {
      if ($param == '_reset')
      {
        $this->setFilterParam(' ');
        $this->setFilters(array());
      }
      // parametry filtru będą zawsze zmieniane w sesji
      //else if ($this->hasFiltersFromLink($param))
      //  $this->setFilterParam($param);
      else
      {
        $filters = $this->getFilterArrayForParam($param);
        
        $filterForm = $this->configuration->getFilterFormWithoutCSRF($filters);
        $filterForm->bind($filters);
        
        
        if ($filterForm->isValid())
        {
          artDebug::logWarning("arteneotheme: filterAction: executeLinkFilter(): formValid");
          
          $this->setFiltersFromLink($filterForm->getValues(), $param);
        }else
        {
          artDebug::logWarning("arteneotheme: filterAction: executeLinkFilter(): form is not valid: ");
        }
    
      }
    }
    
    $paramsList = $this->getParamsList();
    
    if ($request->isXmlHttpRequest())
      $this->forward('<?php echo $this->getModuleName() ?>', 'index'.$paramsList);
    else
      $this->redirect('@<?php echo $this->getUrlForAction('list') ?>'.$paramsList);
  }
  
  public function getLinkFilterArray($paramArray = null)
  {
    return array();
  }
  
  protected function getParamsList()
  {
    if (!isset ($this->request))
      return '';
      
    $paramArray = $this->request->getParameterHolder()->getAll();  
    
    unset($paramArray['module']);
    unset($paramArray['action']);
    unset($paramArray['sf_format']);
    
    $paramsList = '';
    
    if (!empty($paramArray))
    {
      $paramsList = '?';
    
      foreach ($paramArray as $key => $value)
      {
        if ($paramsList != '?') 
          $paramsList .= '&';
          
        $paramsList .= urlencode($key).'='.urlencode($value);
      }
      
    }
    
    return $paramsList;
  }