  protected function processForm(sfWebRequest $request, sfForm $form)
  {
    $followParameters = $request->getParameter('follow_parameters');

    $redirectString = $this->configuration->getFollowParametersString($followParameters);
    $redirectStringWithQuestionMark = $this->configuration->getFollowParametersStringWithQuestionMark($followParameters);
    
    $form->bind($request->getParameter($form->getName()), $request->getFiles($form->getName()));
    
    if ($form->isValid())
    {
      $notice = $form->getObject()->isNew() ? 'Obiekt został utworzony pomyślnie.' : 'Element został zaktualizowany.';

      try {
        $<?php echo $this->getSingularName() ?> = $form->save();
      } 
      catch (Doctrine_Validator_Exception $e) 
      {
        $errorStack = $form->getObject()->getErrorStack();
        $message = get_class($form->getObject()) . ' has ' . count($errorStack) . " field" . (count($errorStack) > 1 ?  's' : null) . " with validation errors: ";
        
        foreach ($errorStack as $field => $errors)
            $message .= "$field (" . implode(", ", $errors) . "), ";

        $message = trim($message, ', ');

        $this->getUser()->setFlash('error', $message);
        return sfView::SUCCESS;
      }
    
      if ($this->configuration->getFormDebug())
        return sfView::NONE;

      $this->dispatcher->notify(new sfEvent($this, 'admin.save_object', array('object' => $<?php echo $this->getSingularName() ?>)));

      if ($request->hasParameter('_save_and_add'))
      {
        $this->getUser()->setFlash('notice', $notice.' Możesz teraz dodać kolejny.');

        $this->redirect('@' . $this->configuration->getRoutePrefix() . '_new' . $redirectStringWithQuestionMark);
      }
      else
      {
        $this->getUser()->setFlash('notice', $notice);

        $this->redirect('@' . $this->configuration->getRoutePrefix() . '_edit?id=' . $<?php echo $this->getSingularName() ?>->getId() . $redirectString);
      }
    }
    else
      $this->getUser()->setFlash('error', 'Obiekt nie został utworzony, wystąpiły błędy.', false);
  }
