[?php

/**
 * <?php echo $this->getModuleName() ?> module configuration.
 *
 * @package    ##PROJECT_NAME##
 * @subpackage <?php echo $this->getModuleName()."\n" ?>
 * @author     ##AUTHOR_NAME##
 * @version    SVN: $Id: helper.php 24171 2009-11-19 16:37:50Z Kris.Wallsmith $
 */
abstract class Base<?php echo ucfirst($this->getModuleName()) ?>GeneratorHelper extends sfModelGeneratorHelper
{

  public $configuration;
  public $followParametersString = null;
  public $followParametersStringWithQuestionMark = null;
  
  public function setConfigurationObject($configuration)
  {
    $this->configuration = $configuration;
  }

  public function preLinkTo()
  {
    if (is_null($this->followParametersString))
    {
      $request = sfContext::getInstance()->getRequest();
      $this->followParametersString = $this->configuration->getFollowParametersString($request);
      $this->followParametersStringWithQuestionMark = $this->configuration->getFollowParametersStringWithQuestionMark($request);
    }
  }
  
  public function linkToNew($params)
  {
    $this->preLinkTo();
    artEscaper::setDefaultInArray($params, 'linkParams', array());
    $url =  '@<?php echo $this->params['route_prefix'] ?>_new' . $this->followParametersStringWithQuestionMark;
    return '<a class="btn btn-primary btn-sm" href="'.url_for($url).'" style="margin-bottom: 5px;"><i class="icon-plus"></i> '. __('Nowy', array(), 'sf_admin') .'</a>';
  }

  public function linkToEdit($object, $params)
  {
    $this->preLinkTo();
    $url =  '@<?php echo $this->params['route_prefix'] ?>_edit?<?php echo $this->getPrimaryKeys(true) ?>=' . $object->get('<?php echo $this->getPrimaryKeys(true) ?>') . $this->followParametersString;
    return '<a class="btn btn-primary btn-sm" href="'.url_for($url).'"><i class="icon-edit"></i> '. __('Edycja', array(), 'sf_admin') .'</a>';
  }

  public function linkToList($params)
  {
    $this->preLinkTo();
    $url =  '@<?php echo $this->params['route_prefix'] ?>'. $this->followParametersStringWithQuestionMark;
    return '<a class="btn btn-primary btn-sm" href="'.url_for($url).'"><i class="icon-list"></i> '. __('Powrót do listy', array(), 'sf_admin') .'</a>';
  }  
  
  public function getUrlForAction($action)
  {
    return 'list' == $action ? '<?php echo $this->params['route_prefix'] ?>' : '<?php echo $this->params['route_prefix'] ?>_'.$action;
  }
  
  public function linkToDelete($object, $params)
  {
    //return parent::linkToDelete($object, $params);
    if ($object->isNew())
      return '';
      
    $this->preLinkTo();
    $name = '<i class="icon-trash"></i> ' . __('Usuń', array(), 'sf_admin');
    $url = $this->getUrlForAction('delete');
    $options = array(
      'class' => 'btn btn-danger btn-sm',
      'method' => 'delete',
      'confirm' => !empty($params['confirm']) ? __('Czy jesteś pewien?', array(), 'sf_admin') : $params['confirm'],
      'query_string' => substr($this->followParametersString, 1)
    );

    return link_to($name, $url, $object, $options);
  }
  
  public function linkToSave($object, $params)
  {
    return '<button type="submit" class="btn btn-success"><i class="icon-ok"></i> '. __('Zapisz', array(), 'sf_admin') .'</button>';
  }
  
   public function linkToSaveAndAdd($object, $params)
  {
    if (!$object->isNew()) {
      return '';
    }
    
    return '<button type="submit" class="btn btn-success btn-sm" name="_save_and_add"><i class="icon-ok"></i> '. __('Zapisz i dodaj', array(), 'sf_admin') .'</button>';
  }
}
