  public function executeBatch(sfWebRequest $request)
  {
    $request->checkCSRFProtection();
    
    $url = '@<?php echo $this->getUrlForAction('list') ?>' . $this->configuration->getFollowParametersStringWithQuestionMark($request);

    if (!$ids = $request->getParameter('ids'))
    {
      $this->getUser()->setFlash('error', 'Musisz wybrać co najmniej jeden element.');
      $this->redirect($url);
    }

    if (!$action = $request->getParameter('batch_action'))
    {
      $this->getUser()->setFlash('error', 'Wybierz akcje aby ją wykonać na zaznaczonych elementach.');
      $this->redirect($url);
    }

    if (!method_exists($this, $method = 'execute'.ucfirst($action)))
      throw new InvalidArgumentException(sprintf('You must create a "%s" method for action "%s"', $method, $action));

    if (!$this->getUser()->hasCredential($this->configuration->getCredentials($action)))
      $this->forward(sfConfig::get('sf_secure_module'), sfConfig::get('sf_secure_action'));

    $validator = new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => '<?php echo $this->getModelClass() ?>'));
    
    try
    {
      // validate ids
      $ids = $validator->clean($ids);
      // execute batch
      $this->$method($request);
    }
    catch (sfValidatorError $e)
    {
      $this->getUser()->setFlash('error', 'Wystąpił problem, ponieważ część z zaznaczonych rekordów nie istnieje.');
    }

    $this->redirect($url);
  }

  protected function executeBatchDelete(sfWebRequest $request)
  {
    $ids = $request->getParameter('ids');

    $records = Doctrine_Query::create()
      ->from('<?php echo $this->getModelClass() ?>')
      ->whereIn('<?php echo $this->getPrimaryKeys(true) ?>', $ids)
      ->execute();

    foreach ($records as $record)
    {
      $record->delete();
    }

    $url = '@<?php echo $this->getUrlForAction('list') ?>' . $this->configuration->getFollowParametersStringWithQuestionMark($request);
    $this->getUser()->setFlash('notice', 'Zaznaczone elementy zostały usunięte pomyślnie.');
    $this->redirect($url);
  }
