  public function executeIndex(sfWebRequest $request)
  {
    $filterDefaults = $this->configuration->getFilterDefaults();
    
    if (!$this->hasFilters() && !empty($filterDefaults))
      $this->executeFilter($request);
      
    // sorting
    if ($request->getParameter('sort') && $this->isValidSortColumn($request->getParameter('sort')))
    {
      $this->setSort(array($request->getParameter('sort'), $request->getParameter('sort_type')));
      $this->redirect('@<?php echo $this->getUrlForAction('list') ?>' . $this->configuration->getFollowParametersStringWithQuestionMark($request));
    }

    // pager
    if ($request->getParameter('page'))
      $this->setPage($request->getParameter('page'));

    $this->pager = $this->getPager();
    $this->sort = $this->getSort();
    $this->horizontal = $this->getHorizontalQuery();
    $this->vertical = $this->getVerticalQuery();
    $this->result = $this->getResultQuery();
    $this->countHorizontal = $this->getHorizontalQuery()->count();
  }
  
  public function getHorizontalQuery()
  {
    $table_method = $this->configuration->getHorizontalTableMethod();
  
    $query = Doctrine_Core::getTable('<?php echo $this->configuration->getHorizontalModel() ?>')
      ->createQuery('a');
      
    if ($table_method != '')
    {
      $query = Doctrine_Core::getTable('<?php echo $this->configuration->getHorizontalModel() ?>')->$table_method($query);
    }
    
    return $query->execute();
  }
  
  public function getVerticalQuery()
  {
    $table_method = $this->configuration->getVerticalTableMethod();
    
    $query = Doctrine_Core::getTable('<?php echo $this->configuration->getVerticalModel() ?>')
            ->createQuery('a');
    
    if($table_method != '')
    {
      $query = Doctrine_Core::getTable('<?php echo $this->configuration->getVerticalModel() ?>')->$table_method($query);
    }
    
    return $query->execute();
  }
  
  public function getResultQuery()
  {
    $table_method = $this->configuration->getResultTableMethod();
    
    $query = Doctrine_Core::getTable('<?php echo $this->configuration->getResultModel() ?>')
            ->createQuery('a');
    
    if($table_method != '')
    {
      $query = Doctrine_Core::getTable('<?php echo $this->configuration->getResultModel() ?>')->$table_method($query);
    }
    
    return $query->execute();
  }