[?php

/**
 * <?php echo $this->getModuleName() ?> module configuration.
 *
 * @package    ##PROJECT_NAME##
 * @subpackage <?php echo $this->getModuleName()."\n" ?>
 * @author     ##AUTHOR_NAME##
 * @version    SVN: $Id: helper.php 24171 2009-11-19 16:37:50Z Kris.Wallsmith $
 */
abstract class Base<?php echo ucfirst($this->getModuleName()) ?>GeneratorHelper extends sfModelGeneratorHelper
{

  public $configuration;
  public $followParametersString = null;
  public $followParametersStringWithQuestionMark = null;
  
  public function setConfigurationObject($configuration)
  {
    $this->configuration = $configuration;
  }

  public function preLinkTo()
  {
    if (is_null($this->followParametersString))
    {
      $request = sfContext::getInstance()->getRequest();
      $this->followParametersString = $this->configuration->getFollowParametersString($request);
      $this->followParametersStringWithQuestionMark = $this->configuration->getFollowParametersStringWithQuestionMark($request);
    }
  }
  
  public function linkToNew($params)
  {
    $this->preLinkTo();
    $url =  '@<?php echo $this->params['route_prefix'] ?>_new' . $this->followParametersStringWithQuestionMark;
    return '<li class="sf_admin_action_new">' . link_to(__($params['label'], array(), 'sf_admin'), $url) . '</li>';
  }

  public function linkToEdit($object, $params)
  {
    $this->preLinkTo();
    $url =  '@<?php echo $this->params['route_prefix'] ?>_edit?id=' . $object->getId() . $this->followParametersString;
    return '<li class="sf_admin_action_edit">' . link_to(__($params['label'], array(), 'sf_admin'), $url, $object) . '</li>';
  }

  public function linkToList($params)
  {
    $this->preLinkTo();
    $url =  '@<?php echo $this->params['route_prefix'] ?>'. $this->followParametersStringWithQuestionMark;
    return '<li class="sf_admin_action_list">'.link_to(__($params['label'], array(), 'sf_admin'), $url) . '</li>';
  }  
  
  public function getUrlForAction($action)
  {
    return 'list' == $action ? '<?php echo $this->params['route_prefix'] ?>' : '<?php echo $this->params['route_prefix'] ?>_'.$action;
  }
  
  public function linkToDelete($object, $params)
  {
    //return parent::linkToDelete($object, $params);
    if ($object->isNew())
      return '';
      
    $this->preLinkTo();
    
    $name = __($params['label'], array(), 'sf_admin');
    $url = $this->getUrlForAction('delete');
    $options = array(
      'method' => 'delete', 
      'confirm' => !empty($params['confirm']) ? __($params['confirm'], array(), 'sf_admin') : $params['confirm'],
      'query_string' => substr($this->followParametersString, 1)
    );

    $linkTo = link_to($name, $url, $object, $options);
    
    return '<li class="sf_admin_action_delete">'. $linkTo .'</li>';
  }
  
}
