[?php

/**
 * <?php echo $this->getModuleName() ?> module configuration.
 *
 * @package    ##PROJECT_NAME##
 * @subpackage <?php echo $this->getModuleName()."\n" ?>
 * @author     ##AUTHOR_NAME##
 * @version    SVN: $Id: configuration.php 24171 2009-11-19 16:37:50Z Kris.Wallsmith $
 */
abstract class Base<?php echo ucfirst($this->getModuleName()) ?>GeneratorConfiguration extends sfModelGeneratorConfiguration
{

  public $followParametersString = null;
  public $followParametersStringWithQuestionMark = null;
  
<?php include dirname(__FILE__).'/actionsConfiguration.php' ?>

<?php include dirname(__FILE__).'/fieldsConfiguration.php' ?>
  
<?php include dirname(__FILE__).'/filtersConfiguration.php' ?>
  
<?php include dirname(__FILE__).'/chartConfiguration.php' ?>

  /**
   * Gets the form class name.
   *
   * @return string The form class name
   */
  public function getFormClass()
  {
    return '<?php echo isset($this->config['form']['class']) ? $this->config['form']['class'] : $this->getModelClass().'Form' ?>';
<?php unset($this->config['form']['class']) ?>
  }

  public function hasFilterForm()
  {
    return <?php echo !isset($this->config['filter']['class']) || false !== $this->config['filter']['class'] ? 'true' : 'false' ?>;
  }

  /**
   * Gets the filter form class name
   *
   * @return string The filter form class name associated with this generator
   */
  public function getFilterFormClass()
  {
    return '<?php echo isset($this->config['filter']['class']) && !in_array($this->config['filter']['class'], array(null, true, false), true) ? $this->config['filter']['class'] : $this->getModelClass().'FormFilter' ?>';
<?php unset($this->config['filter']['class']) ?>
  }

<?php include dirname(__FILE__).'/paginationConfiguration.php' ?>

<?php include dirname(__FILE__).'/reportConfiguration.php' ?>

<?php include dirname(__FILE__).'/sortingConfiguration.php' ?>

  public function getTableMethod()
  {
    return '<?php echo isset($this->config['list']['table_method']) ? $this->config['list']['table_method'] : null ?>';
<?php unset($this->config['list']['table_method']) ?>
  }

  public function getTableCountMethod()
  {
    return '<?php echo isset($this->config['list']['table_count_method']) ? $this->config['list']['table_count_method'] : null ?>';
<?php unset($this->config['list']['table_count_method']) ?>
  }
  
  public function getFollowParametersString($source)
  {
    if (is_null($this->followParametersString))
      $this->setFollowParametersStrings($source);
      
    return $this->followParametersString;
  }
  
  public function getFollowParametersStringWithQuestionMark($source)
  {
    if (is_null($this->followParametersStringWithQuestionMark))
      $this->setFollowParametersStrings($source);
      
    return $this->followParametersStringWithQuestionMark;
  }
  
  protected function setFollowParametersStrings($source)
  {
    if ($source instanceof sfOutputEscaperObjectDecorator)
      $source = $source->getRawValue();
      
    foreach ($this->getPassParameters() as $i => $param)
    {
      $value = '';
      
      if (is_array($source))
        $value = isset($source[$param]) ? $source[$param] : '';
      else if ($source instanceof sfWebRequest)
        $value = $source->getParameter($param, '');

      if ($value != '')
        $this->followParametersString .= '&' . $param . '=' . $value;
    }

    if (!is_null($this->followParametersString))
      $this->followParametersStringWithQuestionMark = '?' . substr($this->followParametersString, 1);
    else
      $this->followParametersStringWithQuestionMark = '';
  }
  
  public function getActionsPositions()
  {
    <?php $positions = isset($this->config['form']['actions_positions']) && ($this->config['form']['actions_positions'] != '~') ? $this->config['form']['actions_positions'] : array('bottom'); ?>
    return <?php echo $this->asPhp($positions); ?>;
<?php unset($this->config['form']['actions_positions']) ?>
  }
  
  <?php $bottomDefaultActions = in_array('bottom', $positions) ? '~' : array(); ?>
  public function getBottomFormActionsPosition()
  {
    return <?php echo $this->asPhp(isset($this->config['form']['actions_place']['bottom']) && ($this->config['form']['actions_place']['top'] != '~') ? $this->config['form']['actions_place']['bottom'] : $bottomDefaultActions) ?>;
<?php unset($this->config['form']['actions_place']['bottom']) ?>
  }
  <?php $topDefaultActions = in_array('top', $positions) ? '~' : array(); ?>
  public function getTopFormActionsPosition()
  {
    return <?php echo $this->asPhp(isset($this->config['form']['actions_place']['top']) && ($this->config['form']['actions_place']['top'] != '~') ? $this->config['form']['actions_place']['top'] : $topDefaultActions) ?>;
<?php unset($this->config['form']['actions_place']['top']) ?>
<?php unset($this->config['form']['actions_place']) ?>
  }
}
