public function executeExportExcel(sfWebRequest $request)
  {    
    $response = $this->getResponse();
    $file = "uploads/" . $this->getModuleName() . "_" . date("Ymd_Hi") . ".xlsx";
    $this->createExcelFile($file);
    $response->clearHttpHeaders();
    $response->addCacheControlHttpHeader('Cache-control', 'must-revalidate, post-check=0, pre-check=0');
    $response->setContentType('application/force-download', TRUE);
    $response->setHttpHeader('Content-Transfer-Encoding', 'binary', TRUE);
    $response->setHttpHeader('Content-Disposition', 'attachment; filename=' . basename($file), TRUE);
    $response->setHttpHeader('Content-Length', filesize($file), true);
    $response->sendHttpHeaders();
	
    @readfile($file);
	
    return sfView::NONE;
  }
  protected function parseExcelResults($results) {
    return $results;
  }
  protected function createExcelFile($filePath)
  {
    // pager
    $this->pager = $this->getPager();
    $this->pagerResults = $this->pager->getAllResults()->toArray();
    $this->pagerResults = $this->parseExcelResults($this->pagerResults);
        
    //Przygotowania pliku do zapisu
    $objPHPExcel = new PHPExcel(); //Utworzenie obiektu PHPExcel
    $objPHPExcel->setActiveSheetIndex(0); //Ustawienie aktywnego arkusza
    
    $columnsNames = $this->configuration->getListDisplay();
    $col = 0;
    $row = 1;
    
    <?php foreach ($this->configuration->getValue('list.display') as $name => $field): ?>
    
      $columnName = __('<?php echo $field->getConfig('label', '', true)?>');
      $cell = $this->getNameFromNumber($col) . $row;
      $objPHPExcel->getActiveSheet()->SetCellValue($cell, $columnName);
      $objPHPExcel->getActiveSheet()->getColumnDimension($this->getNameFromNumber($col))->setAutoSize(true);
      $col++;
      
    <?php endforeach; ?>
    $row++;
    
    foreach ($this->pager->getAllResults() as $i => $<?php echo $this->getSingularName() ?>)
    {
      $col = 0;
      <?php foreach ($this->configuration->getValue('list.display') as $name => $field): ?>
        $element = <? echo $this->getColumnGetter($field->getName(), true);?>;
        $cell = $this->getNameFromNumber($col) . $row;
        $objPHPExcel->getActiveSheet()->SetCellValue($cell, $element);
        $objPHPExcel->getActiveSheet()->getColumnDimension($this->getNameFromNumber($col))->setAutoSize(true);
        $col++;
      <?php endforeach; ?>
      $row++;
    }
    
/*    foreach($this->pagerResults as $result)
    {
      $col = 0;
      foreach($result as $element)
      {
        $cell = $this->getNameFromNumber($col) . $row;
        $objPHPExcel->getActiveSheet()->SetCellValue($cell, $element);
        $objPHPExcel->getActiveSheet()->getColumnDimension($this->getNameFromNumber($col))->setAutoSize(true);
        $col++;
      }
      $row++;
    }
  */  
    //Zapis do pliku
    $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
    $objWriter->save($filePath);
    
  } 
  
  function getNameFromNumber($num) 
  {
    $numeric = $num % 26;
    $letter = chr(65 + $numeric);
    $num2 = intval($num / 26);
    if ($num2 > 0) {
        return getNameFromNumber($num2 - 1) . $letter;
    } else {
        return $letter;
    }
  }