  public function executeFilter(sfWebRequest $request)
  {
    $this->setPage(1);
    $followParameters = $this->configuration->getFollowParametersStringWithQuestionMark($request);
    
    if ($request->hasParameter('_reset'))
    {
      $this->setFilters($this->configuration->getFilterDefaults());
      $this->redirect('@<?php echo $this->getUrlForAction('list') ?>'. $followParameters);
    }
    
    $this->filters = $this->configuration->getFilterForm($this->getFilters());
    
    if ($this->hasFilters())
      $filterValues = $request->getParameter($this->filters->getName());
    else
    {
      unset($this->filters['_csrf_token']);
      $filterValues = $this->configuration->getFilterDefaults();
    }

    $this->filters->bind($filterValues);
    
    if ($this->filters->isValid())
    {
      $this->setFilters($this->filters->getValues());

      $this->redirect('@<?php echo $this->getUrlForAction('list') ?>'. $followParameters);
    }

    $this->pager = $this->getPager();
    
    $this->chartPager = clone($this->pager);
    
    $this->sort = $this->getSort();
    
    if(!$this->configuration->reportIsEmpty())
      $this->aggregation = $this->buildAggregationQuery();    
    else 
      $this->aggregation = array();

    $this->setTemplate('index');
  }
