  public function executeIndex(sfWebRequest $request)
  {
    $filterDefaults = $this->configuration->getFilterDefaults();
    
    if (!$this->hasFilters() && !empty($filterDefaults))
      $this->executeFilter($request);
  
    // sorting
    if ($request->getParameter('sort') && $this->isValidSortColumn($request->getParameter('sort')))
    {
      $this->setSort(array($request->getParameter('sort'), $request->getParameter('sort_type')));
      $this->redirect('@<?php echo $this->getUrlForAction('list') ?>' . $this->configuration->getFollowParametersStringWithQuestionMark($request));
    }

    // pager
    if ($request->getParameter('page'))
      $this->setPage($request->getParameter('page'));

    $this->pager = $this->getPager();
    
    //klonowanie paginatora i zmiana jego parametrów do wykresu 
    $this->chartPager = clone($this->pager);
    
    $this->sort = $this->getSort();
    
    if(!$this->configuration->reportIsEmpty())
      $this->aggregation = $this->buildAggregationQuery();    
    else 
      $this->aggregation = array();
 }  