  public function executeIndexChart(sfWebRequest $request)
  {
    // sorting
    if ($request->getParameter('sort') && $this->isValidSortColumn($request->getParameter('sort')))
    {
      $this->setSort(array($request->getParameter('sort'), $request->getParameter('sort_type')));
    }

    $x_axis = $this->configuration->getX_axis();
    $series = $this->configuration->getSeries();
    $y_axis = $this->configuration->getY_axis();
    // pager

    $this->pager = $this->getPager();
    $this->pager->setMaxPerPage( 1 );
    if ($request->getParameter('page'))
    {
      $this->pager->setPage($request->getParameter('page'));
    }
    $this->pager->init();
    $pagerResult = $this->pager->getResults();

    $numOfSeries;

    foreach( $pagerResult as $object)
      $numOfSeries = $object;
    
    if(!isset($numOfSeries)) $numOfSeries[0] = 1;
    $numberOfSeries = count($numOfSeries); // liczba serii

    $maxPerPage = 500;
    if($numberOfSeries > $maxPerPage) $maxPerPage = $numberOfSeries;

    if( $remaind = $maxPerPage%$numberOfSeries )
    {
      $maxPerPage -= $remaind;
    }
    $this->chartPager = $this->getPager();
    $this->chartPager->setMaxPerPage( $maxPerPage );
    if ($request->getParameter('page'))
    {
      $this->chartPager->setPage($request->getParameter('page'));
    }
    $this->chartPager->init();

    $table = $this->chartPager->getResults();
    $serie_danych=array();
    $jsNazwySeriiDanych = array();
    $jsSerieDanych = array();
    $jsDaty = array();
    
    foreach( $table as $object)
    {
      $serie_danych[$object->$x_axis()][$object->$series()] = $object->$y_axis();
    }
    
    $seriesOfDate = array();
    foreach( $serie_danych as $data => $dane ) 
    {
      $instruments = array();
      $values = array();
      $indexOfInstrument = 0;
      foreach( $dane as $instrumentName => $value )
      {
        $instruments[$indexOfInstrument] = $instrumentName;
        $values[$indexOfInstrument] = $value;
        $indexOfInstrument++;
      }
      $seriesOfDate[$data] = array(
        'serie' => $instruments,
        'dane' => $values
      );
      
    }
   
    $i = 0; // index danych w serii 
    $j = 0; // index serii danych
    
    foreach( $serie_danych as $data => $dane )
    {
      $jsDaty[$i] = $data;
      foreach( $dane as $instrument => $wartosc )
      {
        $jsNazwySeriiDanych[$j] = $instrument;
        $jsSerieDanych[$j][$i] = $wartosc;
        $j++;
      }
      $i++;
    $j = 0;
    }

   foreach( $jsDaty as $key =>$dates)
     $jsDaty[$key] = date('Y-m-d', strtotime($dates));

    $maxPoint = $this->configuration->getMaxPointPerScreen();
    $step = 0;
    
    $avgDateArray = array();
    $avgDataArray = array();

    $step = ceil($this->chartPager->count() / $maxPoint);
    for( $i=0; $i< count($jsDaty); $i+=$step )
    {
      $dataTemp = array();
      $avgDateArray[] = $jsDaty[$i];
      $notNull = array();

      for( $j=0; $j < count($jsNazwySeriiDanych); $j++ )
        for($k=$i; ($k < $step+$i) && ($k < count($jsSerieDanych[$j])); $k++ )
          if($jsSerieDanych[$j][$k] != 0)
          {
            if(isset($dataTemp[$j]))
              $dataTemp[$j] += $jsSerieDanych[$j][$k];
            else
            {
              $dataTemp[$j] = $jsSerieDanych[$j][$k];
            }
            (isset($notNull[$j])) ? $notNull[$j]++ : $notNull[$j] = 1;
          }

      for( $j = 0; $j < count($jsNazwySeriiDanych) ; $j++ )
        if( isset($notNull[$j]))
          $avgDataArray[$j][] = round($dataTemp[$j]/$notNull[$j], 2);
        else
          $avgDataArray[$j][] = 0.1;
    }
    
    // obliczanie max 
    $maxOfActualPage = 0;
    
    foreach( $jsSerieDanych as $i => $value )
      if( $maxOfActualPage < max($value) )
        $maxOfActualPage = max($value);
    
    $jsonCode = array(
          'dataArray'=> $jsSerieDanych,
          'dateArray' => $jsDaty, 
          'smallData' => $avgDataArray,
          'smallDate' => $avgDateArray,
          'namesArray' => $jsNazwySeriiDanych,
          'pageCount' => $this->chartPager->getLastPage(),
          'actualPage' => $this->chartPager->getPage(),
          'max' => $maxOfActualPage,
          'numberOfResults' => $this->chartPager->count(),
          'chartLenght' => $this->configuration->getMaxPointPerScreen(),
          'lineStyle' => $this->configuration->chartLineStyle());
          
    //artDebug::var_dump($this->results);
    return $this->renderText(json_encode($jsonCode));
  }