public function executeExportCsv(sfWebRequest $request)
  {    
    $response = $this->getResponse();
    $file = "uploads/" . $this->getModuleName() . "_" . date("Ymd_Hi") . ".csv";
    $this->createCSVFile($file);
    $response->clearHttpHeaders();
    $response->addCacheControlHttpHeader('Cache-control', 'must-revalidate, post-check=0, pre-check=0');
    $response->setContentType('application/force-download', TRUE);
    $response->setHttpHeader('Content-Transfer-Encoding', 'binary', TRUE);
    $response->setHttpHeader('Content-Disposition', 'attachment; filename=' . basename($file), TRUE);
    $response->setHttpHeader('Content-Length', filesize($file), true);
    $response->sendHttpHeaders();
	
    @readfile($file);
	
    return sfView::NONE;
  }
 
  protected function createCSVFile($filePath)
  {
    // pager
    $this->pager = $this->getPager();
    $this->pagerResults = $this->pager->getAllResults();
    $results = $this->getResultsArray();
    
    $horizontalNames = $this->getHorizontalNames();
    $verticalName = ucfirst($this->configuration->getInputVertical());
       
    $fp = fopen($filePath, 'w');
    $field = array();
    $field[] = $verticalName;
      foreach($horizontalNames as $columnName)
        $field[] = $columnName;
    fputcsv($fp, $field);

    foreach($results as $key => $value)
    {
      $field = array();
      $field[] = $key;
      foreach($value as $element)
        $field[] = $element;
      fputcsv($fp, $field);
    }
    fclose($fp);
  }
