public function executeExportExcel(sfWebRequest $request)
  {    
    $response = $this->getResponse();
    $file = "uploads/" . $this->getModuleName() . "_" . date("Ymd_Hi") . ".xlsx";
    $this->createExcelFile($file);
    $response->clearHttpHeaders();
    $response->addCacheControlHttpHeader('Cache-control', 'must-revalidate, post-check=0, pre-check=0');
    $response->setContentType('application/force-download', TRUE);
    $response->setHttpHeader('Content-Transfer-Encoding', 'binary', TRUE);
    $response->setHttpHeader('Content-Disposition', 'attachment; filename=' . basename($file), TRUE);
    $response->setHttpHeader('Content-Length', filesize($file), true);
    $response->sendHttpHeaders();
	
    @readfile($file);
	
    return sfView::NONE;
  }
  
  protected function createExcelFile($filePath)
  {
    // pager
    $this->pager = $this->getPager();
    $this->pagerResults = $this->pager->getAllResults();
    $results = $this->getResultsArray();
     
    $horizontalNames = $this->getHorizontalNames();
    $verticalName = ucfirst($this->configuration->getInputVertical());
    
    //Przygotowania pliku do zapisu
    $objPHPExcel = new PHPExcel(); //Utworzenie obiektu PHPExcel
    $objPHPExcel->setActiveSheetIndex(0); //Ustawienie aktywnego arkusza
    
    $locale = 'en';
    $validLocale = PHPExcel_Settings::setLocale($locale);
    
    $row = 1;
    $col = 0;
    
    //ustawianie nagłówków tabeli
    $cell = $this->getNameFromNumber($col) . $row;
    $objPHPExcel->getActiveSheet()->SetCellValue($cell, $verticalName);
    $objPHPExcel->getActiveSheet()->getStyle($cell)->getFont()->setBold(true);
    $objPHPExcel->getActiveSheet()->getColumnDimension($this->getNameFromNumber($col))->setAutoSize(true);
    $col++;
    foreach($horizontalNames as $columnName)
    {
      $cell = $this->getNameFromNumber($col) . $row;
      $objPHPExcel->getActiveSheet()->SetCellValue($cell, $columnName);
      $objPHPExcel->getActiveSheet()->getStyle($cell)->getFont()->setBold(true);
      $objPHPExcel->getActiveSheet()->getColumnDimension($this->getNameFromNumber($col))->setAutoSize(true);
      $col++;
    }
    $aggregation = $this->configuration->getAggregation();
    foreach($aggregation as $columnName)
    {
      $cell = $this->getNameFromNumber($col) . $row;
      $objPHPExcel->getActiveSheet()->SetCellValue($cell, ucfirst($columnName));
      $objPHPExcel->getActiveSheet()->getStyle($cell)->getFont()->setBold(true);
      $objPHPExcel->getActiveSheet()->getColumnDimension($this->getNameFromNumber($col))->setAutoSize(true);
      $col++;
    }
    $row++;
    
    //zapis zawartości do tabeli
    foreach($results as $key => $value)
    {
      $col = 0;
      $cell = $this->getNameFromNumber($col) . $row;
      $objPHPExcel->getActiveSheet()->SetCellValue($cell, $key);
      $objPHPExcel->getActiveSheet()->getColumnDimension($this->getNameFromNumber($col))->setAutoSize(true);
      $col++;
      foreach($value as $element)
      {
        $cell = $this->getNameFromNumber($col) . $row;
        $objPHPExcel->getActiveSheet()->SetCellValue($cell, $element);
        $objPHPExcel->getActiveSheet()->getColumnDimension($this->getNameFromNumber($col))->setAutoSize(true);
        $col++;
      }
      
      //Pionowa agregacja
      $colFormula = $col - 1;
      foreach($aggregation as $formula)
      {
        if($formula == "avg")
          $formula = "average";
        $cell = $this->getNameFromNumber($col) . $row;
        $element = "=" . strtoupper($formula) . '(B' . $row . ':' . $this->getNameFromNumber($colFormula) . $row . ")";
        $objPHPExcel->getActiveSheet()->SetCellValue($cell, $element);
        $objPHPExcel->getActiveSheet()->getStyle($cell)->getFont()->setBold(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension($this->getNameFromNumber($col))->setAutoSize(true);
        $col++;
      }
      $row++;
    }
    
    //Dolna agregacja
    $rowAggreagtion = $row-1;
    foreach($aggregation as $formula)
    {
      $col = 0;
      $cell = $this->getNameFromNumber($col) . $row;
      $objPHPExcel->getActiveSheet()->SetCellValue($cell, ucfirst($formula));
      $objPHPExcel->getActiveSheet()->getStyle($cell)->getFont()->setBold(true);
      $objPHPExcel->getActiveSheet()->getColumnDimension($this->getNameFromNumber($col))->setAutoSize(true);
      $col++;
      
      if($formula == "avg")
        $formula = "average";
      foreach($horizontalNames as $name)
      {
        $cell = $this->getNameFromNumber($col) . $row;
        $element = "=" . strtoupper($formula) . '(' . $this->getNameFromNumber($col) . 2 . ':' . $this->getNameFromNumber($col) . $rowAggreagtion . ")";
        $objPHPExcel->getActiveSheet()->SetCellValue($cell, $element);
        $objPHPExcel->getActiveSheet()->getStyle($cell)->getFont()->setBold(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension($this->getNameFromNumber($col))->setAutoSize(true);
        $col++;
      }
      foreach($aggregation as $formula2)
      {
        if($formula2 == "avg")
          $formula2 = "average";
        if($formula2 == $formula)
        {
          $cell = $this->getNameFromNumber($col) . $row;
          $element = "=" . strtoupper($formula) . '(' . $this->getNameFromNumber($col) . 2 . ':' . $this->getNameFromNumber($col) . $rowAggreagtion . ")";
          $objPHPExcel->getActiveSheet()->SetCellValue($cell, $element);
          $objPHPExcel->getActiveSheet()->getStyle($cell)->getFont()->setBold(true);
          $objPHPExcel->getActiveSheet()->getColumnDimension($this->getNameFromNumber($col))->setAutoSize(true);
          $col++;
        }
        else
        {
          $cell = $this->getNameFromNumber($col) . $row;
          $objPHPExcel->getActiveSheet()->SetCellValue($cell, '-');
          $objPHPExcel->getActiveSheet()->getStyle($cell)->getFont()->setBold(true);
          $objPHPExcel->getActiveSheet()->getColumnDimension($this->getNameFromNumber($col))->setAutoSize(true);
          $col++;
        }
      }
      $row++;
    }
    
    //Zapis do pliku
    $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
    $objWriter->save($filePath);
    
  } 
  
  function getNameFromNumber($num) 
  {
    $numeric = $num % 26;
    $letter = chr(65 + $numeric);
    $num2 = intval($num / 26);
    if ($num2 > 0) {
        return getNameFromNumber($num2 - 1) . $letter;
    } else {
        return $letter;
    }
  }