  public function executeIndex(sfWebRequest $request)
  {
    $filterDefaults = $this->configuration->getFilterDefaults();
    
    if (!$this->hasFilters() && !empty($filterDefaults))
      $this->executeFilter($request);
      
    if ($request->getParameter('sort') && $this->isValidSortColumn($request->getParameter('sort')))
    {
      $this->setSort(array($request->getParameter('sort'), $request->getParameter('sort_type')));
      $this->redirect('@<?php echo $this->getUrlForAction('list') ?>' . $this->configuration->getFollowParametersStringWithQuestionMark($request));
    }

    if ($request->getParameter('page'))
      $this->setPage($request->getParameter('page'));

    $this->pager = $this->getPager();
    $this->sort = $this->getSort();
    
    $this->pagerResults = $this->pager->getResults();
    $this->results = $this->getResultsArray();
    $this->horizontalId = $this->getHorizontalId();
    $this->horizontalNames = $this->getHorizontalNames();
    $aggregation = $this->configuration->getAggregation();
    
    if(!empty($aggregation))
      $this->aggregation = $this->buildAggregationQuery();    
    else 
      $this->aggregation = array();
  }
  
   public function getHorizontalNames()
  {
    $function = $this->configuration->getHorizontalNames();
    
    if ($function === false)
    {
      $horizontal = $this->configuration->getInputHorizontal();
      
      $results = Doctrine_Core::getTable('<?php echo $this->getModelClass() ?>')
                    ->createQuery()
                    ->select("distinct($horizontal)")
                    ->execute();
                  
      foreach ($results as $result)
        $names[$result->get('distinct')] = $result->get('distinct');

        return $names;
    }
    else
      return Doctrine_Core::getTable('<?php echo $this->getModelClass() ?>')->$function();
  }
  
  public function getResultsArray()
  {
    $horizontalFunction = $this->configuration->getInputHorizontalFunction();
    $verticalFunction = $this->configuration->getInputVerticalFunction();
    $valueFunction = $this->configuration->getInputValueFunction();

    $results = array();
    $this->horizontalNames = $this->getHorizontalNames();
    $horizontalNames = array();

    foreach ($this->horizontalNames as $i)
      $horizontalNames[$i] = '-';

    foreach ($this->pagerResults as $result)
    {
      $vertical = $result->$verticalFunction();
      $horizontal = $result->$horizontalFunction();

      if (!isset($results[$vertical]))
        $results[$vertical] = $horizontalNames;

      $results[$vertical][$horizontal] = $result->$valueFunction();
    }
    
    return $results;
  }
  