  public function executeIndexChart(sfWebRequest $request)
  {
    if ($request->getParameter('sort') && $this->isValidSortColumn($request->getParameter('sort')))
      $this->setSort(array($request->getParameter('sort'), $request->getParameter('sort_type')));

    $chartPage = $request->getParameter('page', 1);

    $this->sort = $this->getSort();
    $this->pager = $this->getPager(500, $chartPage);

    $this->pagerResults = $this->pager->getResults();
    
    $horizontalFunction = $this->configuration->getInputHorizontalFunction();
    $verticalFunction = $this->configuration->getInputVerticalFunction();
    $valueFunction = $this->configuration->getInputValueFunction();
    
    $this->results = array();
    $this->horizontalNames = $this->getHorizontalNames();
    $horizontalNames = array();
    
    foreach ($this->horizontalNames as $i)
      $horizontalNames[$i] = '0';
    
    foreach ($this->pagerResults as $result)
    {
      $vertical = $result->$verticalFunction();
      $horizontal = $result->$horizontalFunction();
      
      if (!isset($this->results[$vertical]))
        $this->results[$vertical] = $horizontalNames;
    
      $this->results[$vertical][$horizontal] = $result->$valueFunction();
    }
    
    $dataArray = array();
    $dateArray = array();
    $namesArray = array();
    
    $i = 0; // index serii
    $j = 0; // index elementu w serii
    
    foreach( $this->results as $date => $instruments )
    {
      $dateArray[] = $date;
      
      foreach( $instruments as $name => $value )
      {
        $dataArray[$i][$j] = $value;
        $i++;
        if($i == count($this->horizontalNames)) $i = 0;
      }
      
      $j++;
    }
    
    foreach( $dateArray as $key => $dates)
      $dateArray[$key] = date('Y-m-d', strtotime($dates));
    
    // dodanie tablic agregacji
    $aggregationOptions = $this->configuration->getAggregation();    
     
    foreach( $aggregationOptions as $option )
    {
       if($option == 'min') $this->chartMin( $dataArray, count($this->horizontalNames) );
       if($option == 'max') $this->chartMax( $dataArray, count($this->horizontalNames) );
       if($option == 'avg') $this->chartAvg( $dataArray, count($this->horizontalNames) );
       if($option == 'sum') $this->chartSum( $dataArray, count($this->horizontalNames) );
    }
    
      
    
    $maxPoint = $this->configuration->getMaxPointPerScreen();
    $step = 0;
    
    $avgDateArray = array();
    $avgDataArray = array();
   
      $step = ceil($this->pager->count() / $maxPoint);
      for( $i=0; $i< count($dateArray); $i+=$step )
      {
        $dataTemp = array();
        $avgDateArray[] = $dateArray[$i];
        $notNull = array();
        for( $j=0; $j < count($dataArray); $j++ )
          for($k=$i; ($k < $step+$i) && ($k < count($dataArray[$j])); $k++ )
            if($dataArray[$j][$k] != 0)
            {
              if(isset($dataTemp[$j]))
                $dataTemp[$j] += $dataArray[$j][$k];
              else
              {
                $dataTemp[$j] = 0;
                $dataTemp[$j] += $dataArray[$j][$k];
              }
               
              (isset($notNull[$j])) ? $notNull[$j]++ : $notNull[$j] = 1;
            }
        
        for( $j = 0; $j < count($dataArray); $j++ )
        { 
          if( !isset($notNull[$j]) || $notNull[$j] == 0 )
          {
            $notNull[$j] = 1;
            $dataTemp[$j] = 0; 
          }
          
          if( $dataTemp[$j]/$notNull[$j])
            $avgDataArray[$j][] = round($dataTemp[$j]/$notNull[$j], 2);
          else
            $avgDataArray[$j][] = 0;
        }
      }
   
    
    
    // obliczanie max 
    $maxOfActualPage = 0;
    
    for( $i = 0; $i < count($this->horizontalNames); $i++ )
      for( $j = 0; $j < count($dataArray[$i]); $j++)
      if( $maxOfActualPage < max($dataArray[$i]) )
        $maxOfActualPage = max($dataArray[$i]);
    
    // ustawienie serii ktore maja bys wyswietlone
    $seriesToDisplay = array();
    
    for($i = 0; $i < count($this->horizontalNames); $i++ )
      $seriesToDisplay[$i] = $i;  
    
    $seriesNames = array_merge($this->horizontalNames, $aggregationOptions);
    $names = array();
    foreach(  $seriesNames as $key => $value)
      $names[] = $value;

      
    $jsonCode = array(
          'dataArray'=> $dataArray,
          'dateArray' => $dateArray, 
          'smallData' => $avgDataArray,
          'smallDate' => $avgDateArray,
          'namesArray' => $names, //array_merge($this->horizontalNames, $aggregationOptions),
          'pageCount' => $this->pager->getLastPage(),
          'actualPage' => $this->pager->getPage(),
          'max' => $maxOfActualPage,
          'numberOfResults' => $this->pager->count(),
          'chartLenght' => $maxPoint,
          'numberOfSeries' => count($this->horizontalNames),
          'numberOfAggregation' => count($aggregationOptions),
          'seriesToDisplay' => $seriesToDisplay,
          'lineStyle' => $this->configuration->chartLineStyle()
          );
          
    //artDebug::var_dump($this->results);
    return $this->renderText(json_encode($jsonCode));
  }
  
  public function chartMin( &$data, $numberOfSeries )
  {
    $index = count($data); //index tablicy min
    
    for( $j = 0; $j < count($data[$index - 1]); $j++ )
    { 
      $minOfDay = array();
      
      for($i = 0; $i < $numberOfSeries; $i++)
        if( $data[$i][$j] != 0 ) $minOfDay[] = $data[$i][$j];
        
      $data[$index][$j] = min($minOfDay);
    }
  }
  
  public function chartMax( &$data, $numberOfSeries )
  {
    $index = count($data); //index tablicy max
    
    for( $j = 0; $j < count($data[$index - 1]); $j++ )
    {
      $maxOfDay = array();
      
      for( $i = 0; $i < $numberOfSeries; $i++ )
        if( $data[$i][$j] != 0 ) $maxOfDay[] = $data[$i][$j];
        
      $data[$index][$j] = max($maxOfDay);
    }
  }
  
  public function chartSum( &$data, $numberOfSeries )
  {
    $index = count($data); //index tablicy sum
    
    for( $j = 0; $j < count($data[$index - 1]); $j++ )
    {
      $sumOfDay = 0;
      
      for( $i = 0; $i < $numberOfSeries; $i++ )
        $sumOfDay += $data[$i][$j];
        
      $data[$index][$j] = $sumOfDay;
    }
  }
  
  public function chartAvg( &$data, $numberOfSeries )
  {
    $index = count($data); //index tablicy avg
    
    for( $j = 0; $j < count($data[$index - 1]); $j++ )
    {
      $sumOfDay = 0;
      $notNullOfDay = 0;
      
      for( $i = 0; $i < $numberOfSeries; $i++ )
        if( $data[$i][$j] != 0 )
        {
          $sumOfDay += $data[$i][$j];
          $notNullOfDay++;
        }
      
      $data[$index][$j] = round($sumOfDay/$notNullOfDay, 2);
    }
  }