  protected function buildAggregationQuery()
  {
      
    $value = $this->configuration->getInputValue();
	$horizontal = $this->configuration->getInputHorizontal();
	$vertical = $this->configuration->getInputVertical();
	
    <?php if ($this->configuration->hasFilterForm()): ?>
	$filters = $this->configuration->getFilterForm($this->getFilters());
	$tableMethod = $this->configuration->getTableMethod();
    $filters->setTableMethod($tableMethod);
    $queryBase = $filters->buildQuery($this->getFilters());
	<?php else:?>
	$queryBase = $this->buildQuery();
	<?php endif; ?>
	$sql=$queryBase->getSqlQuery();
			 
	$root = $queryBase->getSqlTableAlias($queryBase->getRootAlias());
	$qc=$queryBase->getQueryComponents();
	
	$value_field=$root.'__'.$value;
	$horizontal_field=$root.'__'.$horizontal;
	$vertical_field=$root.'__'.$vertical;
	
	if (!empty ($qc[$queryBase->getRootAlias()]['agg']))
		foreach ($qc[$queryBase->getRootAlias()]['agg'] as $k => $v)
		{
			if ($v == $value ) 
				$value_field=$root.'__'.$k;
			if ($v == $horizontal ) 
				$horizontal_field=$root.'__'.$k;
			if ($v == $vertical ) 
				$vertical_field=$root.'__'.$k;
		}
	
	if (!empty ($qc[$queryBase->getRootAlias()]['map']))
		foreach ($qc[$queryBase->getRootAlias()]['map'] as $k => $v)
		{
			if ($v == $value ) 
				$value_field=$root.'__'.$k;
			if ($v == $horizontal ) 
				$horizontal_field=$root.'__'.$k;
			if ($v == $vertical ) 
				$vertical_field=$root.'__'.$k;
		}
	
	$aggregation = $this->configuration->getAggregation();
    $question = 'agg.'.$horizontal_field.' as '.$horizontal.', ';
    foreach($aggregation as $type) //type: min, max, avg, sum
      $question = $question . strtoupper($type) . "(agg.".$value_field."), ";
	$question = substr($question, 0, -2); 
	
	
	$fullSql = 'select '.$question.' from ('.$sql.') agg group by agg.'.$horizontal_field;
	$connection = Doctrine_Manager::getInstance()->connection();
    $statement = $connection->execute($fullSql,$queryBase->getFlattenedParams());
	
	$result = array();
	foreach ($statement->fetchAll() as $row)
	{
		$r = array();
		$r[$horizontal]=$row[$horizontal];
		foreach($aggregation as $type) //type: min, max, avg, sum
		{ 
			$field_name = strtoupper($type) . "(agg.".$value_field.")";
			$field_name_to = strtoupper($type);
			if (isset ($row[$field_name]))
				$r[$field_name_to]=$row[$field_name];
			
		}
		$result[]=$r;
	
	}
	
    return $result;
  }
  
  public function getHorizontalId()
  {
    $horizontal = $this->configuration->getInputHorizontal();
    $model = '<?php echo $this->getModelClass() ?>';
    return $query = Doctrine_Query::create()
              ->select('DISTINCT (' . $horizontal . ') as instrument_id')
              ->from($model)
              ->groupBy($horizontal)
              ->fetchArray();
  }
