  protected function addSortQuery($query)
  {
    if (array(null, null) == ($sort = $this->getSort()))
      return;

    if (!in_array(strtolower($sort[1]), array('asc', 'desc')))
      $sort[1] = 'asc';

    $fields = $this->configuration->getFieldsDefault();
    $sortType = $sort[1];

    if (!isset($fields[$sort[0]]['sort']))
      $query->addOrderBy($sort[0] . ' ' . $sortType);
    else
    {
      $this->sortOptions = $fields[$sort[0]]['sort'];

      if (!isset($this->sortOptions['custom_function']))
        $this->extendAddSortQuery($query, $sortType);
      else
      {
        $function = 'addOrderBy' . sfInflector::camelize($sort[0]);
        $this->$function($query, $sortType);
      }
    }
  }

  protected function extendAddSortQuery($query, $sortType)
  {
    $dqlPartFrom = $query->getDqlPart('from');
    $sortModel = $this->sortOptions['model'];

    if (isset($this->sortOptions['model_translation_prefix']))
      $sortModel = $this->sortOptions['model_translation_prefix'];
    else if ($query->getRoot()->getComponentName() == $sortModel)
      $sortModel = $query->getRootAlias();
    else
      foreach ($dqlPartFrom as $from)
      {
        $fromPosition = strpos($from, '.' . $sortModel . ' ');

        if ($fromPosition !== false)
        {
          $tab = explode(' ', substr($from, $fromPosition));
          $sortModel = $tab[1];
          break;
        }
      }

    if (isset($this->sortOptions['column']))
    {
      $sortColumn = $this->sortOptions['column'];
      $query->addOrderBy($sortModel . '.' . $sortColumn . ' ' . $sortType);
    }
    else if (isset($this->sortOptions['columns']))
    {
      $sortColumns = $this->sortOptions['columns'];
      $orderBy = '';

      foreach ($sortColumns as $sortColumn)
        $orderBy .= $sortModel . '.' . $sortColumn . ' ' . $sortType . ',';

      $orderBy = substr($orderBy, 0, -1);

      $query->addOrderBy($orderBy);
    }
  }

  protected function getSort()
  {
    if (null !== $sort = $this->getUser()->getAttribute('<?php echo $this->getModuleName() ?>.sort', null, 'admin_module'))
    {
      return $sort;
    }

    $this->setSort($this->configuration->getDefaultSort());

    return $this->getUser()->getAttribute('<?php echo $this->getModuleName() ?>.sort', null, 'admin_module');
  }

  protected function setSort(array $sort)
  {
    if (null !== $sort[0] && null === $sort[1])
    {
      $sort[1] = 'asc';
    }

    $this->getUser()->setAttribute('<?php echo $this->getModuleName() ?>.sort', $sort, 'admin_module');
  }

  protected function isValidSortColumn($column)
  {
    return $this->configuration->isValidSortColumn($column);
  }

  protected function addOrderBySum(Doctrine_Query $query, $sortType)
  {
    $this->orderByAggregation($query, $sortType, 'SUM');
  }
  
  protected function addOrderAvg(Doctrine_Query $query, $sortType)
  {
    $this->orderByAggregation($query, $sortType, 'AVG');
  }
  
  protected function addOrderByMin(Doctrine_Query $query, $sortType)
  {
    $this->orderByAggregation($query, $sortType, 'MIN');
  }
  
  protected function addOrderByMax(Doctrine_Query $query, $sortType)
  {
    $this->orderByAggregation($query, $sortType, 'MAX');
  }
  
  protected function orderByAggregation(Doctrine_Query $query, $sortType, $type)
  {
    $value = $this->configuration->getInputValue();
    $vertical = $this->configuration->getInputVertical();
    $query->addOrderBy("$type($value) $sortType");
//    $query->addGroupBy("$vertical");
//    $query->addGroupBy("$value");
  }