<?php

class artActions extends sfActions {

  /**
   * Konstruktor
   *
   * @param $context
   * @param $moduleName
   * @param $actionName
   */
  public function __construct($context, $moduleName, $actionName) {
    parent::__construct($context, $moduleName, $actionName);

    $this->userCulture = $this->getUser()->getCulture();
  }

  /**
   * Ładuje helper i ustawia zmienne.
   *
   * @param $vars
   */
  protected function loadPartialHelperAndSetVars(&$vars) {
    $this->getContext()->getConfiguration()->loadHelpers('ArteneoPartial');
    $vars = null !== $vars ? $vars : $this->varHolder->getAll();
  }

  /**
   * Pobiera komponent.
   *
   * @param string $moduleName
   * @param string $componentName
   * @param null $vars
   * @return string
   */
  public function getComponent($moduleName, $componentName, $vars = null) {
    $this->loadPartialHelperAndSetVars($vars);

    return get_component($moduleName, $componentName, $vars);
  }

  /**
   * Pobiera partial.
   *
   * @param string $templateName
   * @param null $vars
   * @return string
   */
  public function getPartial($templateName, $vars = null) {
    $this->loadPartialHelperAndSetVars($vars);

    return get_partial($templateName, $vars);
  }

  /**
   * Renderuje partial, jezeli udało się wyrenderować partial - jeżeli nie, to zwraca false
   * @param type $templateName
   * @param type $vars
   * @return type
   */
  public function renderPartialIfExists($templateName, $vars = null) {
    $this->loadPartialHelperAndSetVars($vars);

    return get_partial_if_exists($templateName, $vars);
  }

  /**
   * Funkcja próbuje wyrenderować partiale w kolejności podanej w tablicy $templateNames
   * jeżeli uda się wyrenderować któryś partial, to zwraca jego zawartość,
   * w przeciwnym wypadku zwraca false
   *
   * @param type $templateNames
   * @param type $vars
   * @return string/boolean zawartość partiala lub false, jeżeli nie udało się wyrenderować
   */
  public function renderPartialFromArray($templateNames, $vars = null) {
    $this->loadPartialHelperAndSetVars($vars);

    return get_partial_from_array($templateNames, $vars);
  }

  /**
   * Uruchamia metodę $methodName, jeżeli ta istnieje
   * @param string $methodName nazwa metody
   * @return type zwraca wynik uruchamaniej metody
   */
  public function runMethodIfExists($methodName, $arguments = array()) {
    if (method_exists($this, $methodName))
      return call_user_func_array(array($this, $methodName), $arguments);
  }

  /**
   * Renderuje JSON.
   *
   * @param $value
   * @return string
   */
  public function renderJson($value) {
    return $this->renderText(json_encode($value));
  }

  /**
   * Akcja pobieranie pliku z serwera, zmienna nagówek.
   *
   * @param $file
   * @param null $filename
   * @return string
   */
  protected function downloadFile($file, $filename = null) {
    $filename = is_null($filename) ? basename($file) : $filename;

    $response = $this->getResponse();
    $response->clearHttpHeaders();
    $response->addCacheControlHttpHeader('Cache-control', 'must-revalidate, post-check=0, pre-check=0');
    $response->setContentType(artFile::guessMimeTypeFromFileinfo($file), TRUE);
    $response->setHttpHeader('Content-Transfer-Encoding', 'binary', TRUE);
    $response->setHttpHeader('Content-Disposition', 'attachment; filename="' . $filename . '"', TRUE);
    $response->sendHttpHeaders();

    @readfile($file);

    return sfView::NONE;
  }

  /**
   * Ustawia parametry response.
   *
   * @param $params
   * @return array
   */
  private function setResponseParams($params) {
    $returnArray = array('success' => true, 'excepiton' => false);

    if (!empty($params))
      foreach ($params as $key => $value)
        $returnArray[$key] = $value;

    return $returnArray;
  }

  public function getHtmlContent(sfActions $action, $template = 'Success', $layout = false) {

    sfConfig::set('sf_web_debug', false);
    $action->setLayout($layout);
    $context = $action->getContext();

    $context->getResponse()->clearHttpHeaders();

    $view = $context->getController()->getView($action->getModuleName(), $action->getActionName(), $template);
    $view->execute();
    $view->getAttributeHolder()->add($action->getVarHolder()->getAll());
    $content = $view->render();

    return $content;
  }

  /**
   * Tworzy response JS.
   *
   * @param null $result
   * @param array $params
   * @return string
   */
  public function createJSResponse($result = null, $params = array()) {
    $returnArray = self::setResponseParams($params);

    if ($result != null) {
      $returnArray['result'] = $result;
      $returnArray['source'] = $this->getModuleName() . '.' . $this->getActionName();

      return $this->renderText(json_encode($returnArray));
    } else
      return $this->renderText(json_encode(array($returnArray)));
  }

  /**
   * Ustawia odpowiedź dla akcji w formacie JSON. 
   * 
   * @param array $json_response
   * @return string
   */
  public function setJsonResponse($response) {

    die(json_encode($response));
  }

  /**
   * Modyfikcja funkcji tak aby brała pod uwagę również katalog z pluginów. 
   * 
   * @param type $name
   * @param type $module
   */
  public function setTemplate($name, $module = null) {


    if (sfConfig::get('sf_logging_enabled')) {
      $this->dispatcher->notify(new sfEvent($this, 'application.log', array(sprintf('Change template to "%s/%s"', null === $module ? 'CURRENT' : $module, $name))));
    }

//    if (null !== $module) {
//      $fileName = $name;
//      $plugins = $this->getContext()->getConfiguration()->getAllPluginPaths();
//
//      while (list(, $val) = each($plugins)) {
//        $templateFile = $val . '/modules/' . $module . '/templates/' . $fileName;
//        var_dump(file_exists($templateFile));
//      }
//    }
    
    if (null !== $module) {
      $name = sfConfig::get('sf_app_dir') . '/modules/' . $module . '/templates/' . $name;
    }

    sfConfig::set('symfony.view.' . $this->getModuleName() . '_' . $this->getActionName() . '_template', $name);
  }

}
