<?php

class artFrontWebController extends sfFrontWebController
{

    /**
     * Konstruktor.
     *
     * @param $context
     */
    public function __construct($context)
    {
        parent::__construct($context);

        if (isset($_SERVER['SERVER_NAME']))
            ArtConfiguration::loadConfiguration();
    }

    /**
     * Sprawdza czy kontroler istanieje. Zwraca Exception gdy nie odnaleiono modułu lub akcji.
     *
     * @param string $moduleName
     * @param string $controllerName
     * @param string $extension
     * @param bool $throwExceptions
     * @return bool
     * @throws sfControllerException
     * @throws sfConfigurationException
     */
    protected function controllerExists($moduleName, $controllerName, $extension, $throwExceptions)
    {
        $dirs = $this->context->getConfiguration()->getControllerDirs($moduleName);

        $dirsNames = array_keys($dirs);
        $i = 0;

        foreach ($dirs as $dir => $checkEnabled) {
            // plugin module enabled?
            if ($checkEnabled && !in_array($moduleName, sfConfig::get('sf_enabled_modules')) && is_readable($dir)) {
                throw new sfConfigurationException(sprintf('The module "%s" is not enabled.', $moduleName));
            }

            // check for a module generator config file
            $this->context->getConfigCache()->import('modules/' . $moduleName . '/config/generator.yml', false, true);

            // one action per file or one file for all actions
            $classFile = strtolower($extension);
            $classSuffix = ucfirst(strtolower($extension));
            $file = $dir . '/' . $controllerName . $classSuffix . '.class.php';

            if (is_readable($file)) {
                // action class exists
                require_once($file);
                $this->controllerClasses[$moduleName . '_' . $controllerName . '_' . $classSuffix] = $controllerName . $classSuffix;

                return true;
            }

            $module_file = $dir . '/' . $classFile . 's.class.php';

            if (is_readable($module_file)) {
                //jeżeli ładujemy klasę akcji z aplikacji i istnieje klasa akcji w pluginach, to załaduj najpierw klase akcji z pluginów
                if (isset($dirsNames[$i + 1])) {
                    $pluginModuleFile = $dirsNames[$i + 1] . '/' . $classFile . 's.class.php';

                    if (is_readable($pluginModuleFile) && strpos($pluginModuleFile, sfConfig::get('sf_plugins_dir')) === 0)
                        require_once($pluginModuleFile);
                }

                require_once($module_file);

                $actionsClass = $moduleName . $classSuffix . 's';

                if (!class_exists($actionsClass, false))
                    $actionsClass = 'Plugin' . $actionsClass;

                if (!class_exists($actionsClass, false)) {
                    if ($throwExceptions) {
                        throw new sfControllerException(sprintf('There is no "%s" class in your action file "%s".', $actionsClass, $module_file));
                    }

                    return false;
                }

                // action is defined in this class?
                if (!in_array('execute' . ucfirst($controllerName), get_class_methods($actionsClass))) {
                    if ($throwExceptions) {
                        throw new sfControllerException(sprintf('There is no "%s" method in your action class "%s".', 'execute' . ucfirst($controllerName), $actionsClass));
                    }

                    return false;
                }

                $this->controllerClasses[$moduleName . '_' . $controllerName . '_' . $classSuffix] = $actionsClass;
                return true;
            }

            $i++;
        }

        // send an exception if debug
        if ($throwExceptions && sfConfig::get('sf_debug')) {
            $dirs = array_map(array('sfDebug', 'shortenFilePath'), array_keys($dirs));

            throw new sfControllerException(sprintf('Controller "%s/%s" does not exist in: %s.', $moduleName, $controllerName, implode(', ', $dirs)));
        }

        return false;
    }

    /**
     * Zwraca obiekt sfView
     *
     * @param string $moduleName A module name
     * @param string $actionName An action name
     * @param string $viewName   A view name
     *
     * @return sfView A sfView implementation instance, if the view exists, otherwise null
     */
    public function getView($moduleName, $actionName, $viewName)
    {
        // user view exists?
        $file = sfConfig::get('sf_app_module_dir') . '/' . $moduleName . '/view/' . $actionName . $viewName . 'View.class.php';

        if (is_readable($file)) {
            require_once($file);

            $class = $actionName . $viewName . 'View';

            // fix for same name classes
            $moduleClass = $moduleName . '_' . $class;

            if (class_exists($moduleClass, false)) {
                $class = $moduleClass;
            }
        } else {
                       // view class (as configured in module.yml or defined in action)
            // $class = sfConfig::get('mod_' . strtolower($moduleName) . '_view_class', 'artPHP') . 'View';
            $class = 'artPHPView';
        }

        return new $class($this->context, $moduleName, $actionName, $viewName);
    }

}